--[[
    fmodtable.lua - FMOD Studio API

    Generated path references for project 'fromtheforge.fspro'

    This file is generated by the exportFMODTable.js script located at \contentsource\sound\fromtheforge\Scripts\.

    When playing sounds, if we use exact path names to find the event we are at risk of losing the connection if a sound designer moves the event to a different location in the FMOD Studio project.
    For example, moving event:/Creature/blarmadillo/blarmadillo_shoot to a new folder, event:/Creature/blarmadillo/Weapon/blarmadillo_shoot, breaks the sound hookup.

    Using fmodtable means we refer to the identifier of the event (in this case, the event name 'blarmadillo_shoot') to find the correct path name, whatever it is.
    This insulates the game from FMOD Studio project reorganization.

    NOTICE: This means we cannot have duplicate event names or bus names.
--]]

local fmodtable =
{
    Event =
    {
        _10_slideshow_LP = "Level/SlideShow/10_slideshow_LP",
        _1_slideshow_LP = "Level/SlideShow/1_slideshow_LP",
        _2_slideshow_LP = "Level/SlideShow/2_slideshow_LP",
        _3_slideshow_LP = "Level/SlideShow/3_slideshow_LP",
        _4_slideshow_LP = "Level/SlideShow/4_slideshow_LP",
        _5_slideshow_LP = "Level/SlideShow/5_slideshow_LP",
        _6_slideshow_LP = "Level/SlideShow/6_slideshow_LP",
        _7_slideshow_LP = "Level/SlideShow/7_slideshow_LP",
        _8_slideshow_LP = "Level/SlideShow/8_slideshow_LP",
        _9_slideshow_LP = "Level/SlideShow/9_slideshow_LP",
        AAAA_default_event = "AAAA_default_event",
        acid_LP = "FX/acid_LP",
        add_currency_konjur = "UI/add_currency_konjur",
        alphonse_speech_neutral = "NPC/alphonse_speech_neutral",
        amb_StartingForest_Birds_LP = "Level/StartingForest/amb_StartingForest_Birds_LP",
        amb_StartingForest_LP = "Level/StartingForest/amb_StartingForest_LP",
        amb_Swamp_LP = "Level/Bandiforest/amb_Swamp_LP",
        amb_Town_LP = "Level/Town/amb_Town_LP",
        apothecaryScreen_hide = "UI/screenHideShow/apothecaryScreen_hide",
        apothecaryScreen_show = "UI/screenHideShow/apothecaryScreen_show",
        bandicoot_be4 = "Creature/bandicoot/bandicoot_be4",
        bandicoot_be5 = "Creature/bandicoot/bandicoot_be5",
        bandicoot_be5_intro = "Creature/bandicoot/intro/bandicoot_be5_intro",
        bandicoot_bite = "Creature/bandicoot/bandicoot_bite",
        bandicoot_bodyfall = "Creature/bandicoot/bandicoot_bodyfall",
        bandicoot_breaths1 = "Creature/bandicoot/bandicoot_breaths1",
        bandicoot_breaths1_intro = "Creature/bandicoot/intro/bandicoot_breaths1_intro",
        bandicoot_breaths2 = "Creature/bandicoot/bandicoot_breaths2",
        bandicoot_clone_cast = "Creature/bandicoot/bandicoot_clone_cast",
        bandicoot_clone_kill = "Creature/bandicoot/bandicoot_clone_kill",
        bandicoot_clone_split = "Creature/bandicoot/bandicoot_clone_split",
        bandicoot_death = "Creature/bandicoot/bandicoot_death",
        bandicoot_fart = "Creature/bandicoot/bandicoot_fart",
        bandicoot_flap = "Creature/bandicoot/bandicoot_flap",
        bandicoot_foley = "Creature/bandicoot/bandicoot_foley",
        bandicoot_footstep = "Creature/bandicoot/bandicoot_footstep",
        bandicoot_hands_intro = "Creature/bandicoot/intro/bandicoot_hands_intro",
        bandicoot_hit = "Creature/bandicoot/bandicoot_hit",
        bandicoot_hit_intro = "Creature/bandicoot/intro/bandicoot_hit_intro",
        bandicoot_howl = "Creature/bandicoot/bandicoot_howl",
        bandicoot_howl_intro = "Creature/bandicoot/intro/bandicoot_howl_intro",
        bandicoot_howl_LP = "Creature/bandicoot/bandicoot_howl_LP",
        bandicoot_knock_intro = "Creature/bandicoot/intro/bandicoot_knock_intro",
        bandicoot_laugh = "Creature/bandicoot/bandicoot_laugh",
        bandicoot_laugh2 = "Creature/bandicoot/bandicoot_laugh2",
        bandicoot_pre_bite = "Creature/bandicoot/bandicoot_pre_bite",
        bandicoot_rage = "Creature/bandicoot/bandicoot_rage",
        bandicoot_rage_short = "Creature/bandicoot/bandicoot_rage_short",
        bandicoot_rumble_LP = "Creature/bandicoot/bandicoot_rumble_LP",
        bandicoot_snarl1 = "Creature/bandicoot/bandicoot_snarl1",
        bandicoot_snarl2 = "Creature/bandicoot/bandicoot_snarl2",
        bandicoot_snarl_short = "Creature/bandicoot/bandicoot_snarl_short",
        bandicoot_swipe_hit = "Creature/bandicoot/bandicoot_swipe_hit",
        bandicoot_swipe_pre = "Creature/bandicoot/bandicoot_swipe_pre",
        bandicoot_tailspin = "Creature/bandicoot/bandicoot_tailspin",
        bandicoot_tailspin_short = "Creature/bandicoot/bandicoot_tailspin_short",
        bandicoot_taunt = "Creature/bandicoot/bandicoot_taunt",
        bandicoot_taunt_hit = "Creature/bandicoot/bandicoot_taunt_hit",
        bandicoot_taunt_pre = "Creature/bandicoot/bandicoot_taunt_pre",
        bandicoot_teleport = "Creature/bandicoot/bandicoot_teleport",
        bandicoot_tell = "Creature/bandicoot/bandicoot_tell",
        bandicoot_vo_bits = "Creature/bandicoot/bandicoot_vo_bits",
        bandicoot_vo_bits2 = "Creature/bandicoot/bandicoot_vo_bits2",
        bandicoot_whoosh = "Creature/bandicoot/bandicoot_whoosh",
        base_layer = "Level/Tile_Surface/base_layer",
        base_layer_boss = "Level/Tile_Surface/base_layer_boss",
        battoad_bodyfall = "Creature/battoad/battoad_bodyfall",
        battoad_breath = "Creature/battoad/battoad_breath",
        battoad_chew = "Creature/battoad/battoad_chew",
        battoad_croak = "Creature/battoad/battoad_croak",
        battoad_death = "Creature/battoad/battoad_death",
        battoad_flap = "Creature/battoad/battoad_flap",
        battoad_flap_short = "Creature/battoad/battoad_flap_short",
        battoad_hit1 = "Creature/battoad/battoad_hit1",
        battoad_hit2 = "Creature/battoad/battoad_hit2",
        battoad_hit_short = "Creature/battoad/battoad_hit_short",
        battoad_knockdown = "Creature/battoad/battoad_knockdown",
        battoad_land = "Creature/battoad/battoad_land",
        battoad_puke = "Creature/battoad/battoad_puke",
        battoad_puke_pre = "Creature/battoad/battoad_puke_pre",
        battoad_sharp = "Creature/battoad/battoad_sharp",
        battoad_spit_pre = "Creature/battoad/battoad_spit_pre",
        battoad_swallow = "Creature/battoad/battoad_swallow",
        battoad_swipe = "Creature/battoad/battoad_swipe",
        battoad_tongue_hit = "Creature/battoad/battoad_tongue_hit",
        battoad_upperwings = "Creature/battoad/battoad_upperwings",
        battoad_upperwings_pre_LP = "Creature/battoad/battoad_upperwings_pre_LP",
        beets_bodyfall = "Creature/beets/beets_bodyfall",
        beets_death = "Creature/beets/beets_death",
        beets_footstep = "Creature/beets/beets_footstep",
        beets_headbutt = "Creature/beets/beets_headbutt",
        beets_headbutt_2_elite = "Creature/beets/beets_headbutt_2_elite",
        beets_headbutt_elite = "Creature/beets/beets_headbutt_elite",
        beets_reverse = "Creature/beets/beets_reverse",
        beets_vo = "Creature/beets/beets_vo",
        beets_whoosh = "Creature/beets/beets_whoosh",
        beets_yell = "Creature/beets/beets_yell",
        blarmadillo_armour = "Creature/blarmadillo/blarmadillo_armour",
        blarmadillo_bodyfall = "Creature/blarmadillo/Movement/blarmadillo_bodyfall",
        blarmadillo_bounce = "Creature/blarmadillo/Movement/blarmadillo_bounce",
        blarmadillo_death = "Creature/blarmadillo/Voice/blarmadillo_death",
        blarmadillo_dig = "Creature/blarmadillo/Movement/blarmadillo_dig",
        blarmadillo_Elite_bounce = "Creature/blarmadillo/Elite/blarmadillo_Elite_bounce",
        blarmadillo_Elite_hit = "Creature/blarmadillo/Elite/blarmadillo_Elite_hit",
        blarmadillo_Elite_knockdown = "Creature/blarmadillo/Elite/blarmadillo_Elite_knockdown",
        blarmadillo_Elite_trumpet = "Creature/blarmadillo/Elite/blarmadillo_Elite_trumpet",
        blarmadillo_footstep = "Creature/blarmadillo/Movement/blarmadillo_footstep",
        blarmadillo_hit = "Creature/blarmadillo/Voice/blarmadillo_hit",
        blarmadillo_knockdown = "Creature/blarmadillo/Voice/blarmadillo_knockdown",
        blarmadillo_land = "Creature/blarmadillo/Voice/blarmadillo_land",
        blarmadillo_roll_LP = "Creature/blarmadillo/Movement/blarmadillo_roll_LP",
        blarmadillo_shell = "Creature/blarmadillo/Movement/blarmadillo_shell",
        blarmadillo_shoot = "Creature/blarmadillo/Weapon/blarmadillo_shoot",
        blarmadillo_shoot_LP = "Creature/blarmadillo/Weapon/blarmadillo_shoot_LP",
        blarmadillo_shoot_short = "Creature/blarmadillo/Weapon/blarmadillo_shoot_short",
        blarmadillo_slurp = "Creature/blarmadillo/Movement/blarmadillo_slurp",
        blarmadillo_sneeze = "Creature/blarmadillo/Voice/blarmadillo_sneeze",
        blarmadillo_suck = "Creature/blarmadillo/Movement/blarmadillo_suck",
        blarmadillo_trumpet = "Creature/blarmadillo/Voice/blarmadillo_trumpet",
        blarmadillo_trumpet_tell = "Creature/blarmadillo/Voice/blarmadillo_trumpet_tell",
        blarmadillo_VO = "Creature/blarmadillo/Voice/blarmadillo_VO",
        blarmadillo_VO_sneeze = "Creature/blarmadillo/Voice/blarmadillo_VO_sneeze",
        boss_death = "FX/boss_death",
        building_forge_LP = "Level/Town/shops/building_forge_LP",
        building_forge_sparks = "Level/Town/shops/building_forge_sparks",
        building_marketroom_lamp_LP = "Level/market_room/building_marketroom_lamp_LP",
        building_marketroom_shop_LP = "Level/market_room/building_marketroom_shop_LP",
        building_powerupgrader_LP = "Level/konjurist_room/building_powerupgrader_LP",
        building_powerupgrader_pipe_LP = "Level/konjurist_room/building_powerupgrader_pipe_LP",
        building_powerupgrader_rock_LP = "Level/konjurist_room/building_powerupgrader_rock_LP",
        building_powerupgrader_sparks = "Level/konjurist_room/building_powerupgrader_sparks",
        buildMenu_hide = "UI/buildMenu/buildMenu_hide",
        buildMenu_show = "UI/buildMenu/buildMenu_show",
        bulbug_atk = "Creature/bulbug/bulbug_atk",
        bulbug_bodyfall = "Creature/bulbug/bulbug_bodyfall",
        bulbug_cast = "Creature/bulbug/bulbug_cast",
        bulbug_chat = "Creature/bulbug/bulbug_chat",
        bulbug_death = "Creature/bulbug/bulbug_death",
        bulbug_footstep = "Creature/bulbug/bulbug_footstep",
        bulbug_hit = "Creature/bulbug/bulbug_hit",
        bulbug_jump = "Creature/bulbug/bulbug_jump",
        bulbug_knockdown = "Creature/bulbug/bulbug_knockdown",
        bulbug_sheild = "Creature/bulbug/bulbug_sheild",
        bulbug_vo = "Creature/bulbug/bulbug_vo",
        bunippy_10 = "Creature/bunippy/bunippy_10",
        bunippy_11 = "Creature/bunippy/bunippy_11",
        bunippy_12 = "Creature/bunippy/bunippy_12",
        bunippy_13 = "Creature/bunippy/bunippy_13",
        bunippy_14 = "Creature/bunippy/bunippy_14",
        bunippy_15 = "Creature/bunippy/bunippy_15",
        bunippy_akt_kick_LP = "Creature/bunippy/bunippy_akt_kick_LP",
        bunippy_body_fall = "Creature/bunippy/bunippy_body_fall",
        bunippy_death = "Creature/bunippy/bunippy_death",
        bunippy_footstep = "Creature/bunippy/bunippy_footstep",
        bunippy_vo_hit = "Creature/bunippy/bunippy_vo_hit",
        bunippy_vo_long = "Creature/bunippy/bunippy_vo_long",
        bunippy_vo_short = "Creature/bunippy/bunippy_vo_short",
        bunippy_vo_short2 = "Creature/bunippy/bunippy_vo_short2",
        bunippy_vo_squeal = "Creature/bunippy/bunippy_vo_squeal",
        bunippy_whoosh_LP = "Creature/bunippy/bunippy_whoosh_LP",
        cabbagerolls2_hold = "Creature/cabbageroll/Standard/cabbagerolls2_hold",
        cabbagerolls2_slam = "Creature/cabbageroll/Standard/cabbagerolls2_slam",
        cabbagerolls2_throw = "Creature/cabbageroll/Standard/cabbagerolls2_throw",
        cabbagerolls_slap = "Creature/cabbageroll/Standard/cabbagerolls_slap",
        cabbagerolls_throw = "Creature/cabbageroll/Standard/cabbagerolls_throw",
        cabbageroll_behaviour_1 = "Creature/cabbageroll/Standard/cabbageroll_behaviour_1",
        cabbageroll_behaviour_2 = "Creature/cabbageroll/Standard/cabbageroll_behaviour_2",
        cabbageroll_behaviour_2_3 = "Creature/cabbageroll/Standard/cabbageroll_behaviour_2_3",
        cabbageroll_behaviour_3 = "Creature/cabbageroll/Standard/cabbageroll_behaviour_3",
        cabbageroll_bite = "Creature/cabbageroll/Standard/cabbageroll_bite",
        cabbageroll_bodyfall = "Creature/cabbageroll/Standard/cabbageroll_bodyfall",
        cabbageroll_death = "Creature/cabbageroll/Standard/cabbageroll_death",
        cabbageroll_death_norm = "Creature/cabbageroll/Standard/cabbageroll_death_norm",
        cabbageroll_Elite_behaviour_2 = "Creature/cabbageroll/Elite/cabbageroll_Elite_behaviour_2",
        cabbageroll_Elite_behaviour_2_3 = "Creature/cabbageroll/Elite/cabbageroll_Elite_behaviour_2_3",
        cabbageroll_Elite_behaviour_3 = "Creature/cabbageroll/Elite/cabbageroll_Elite_behaviour_3",
        cabbageroll_Elite_bite = "Creature/cabbageroll/Elite/cabbageroll_Elite_bite",
        cabbageroll_Elite_footstep = "Creature/cabbageroll/Elite/cabbageroll_Elite_footstep",
        cabbageroll_Elite_gather = "Creature/cabbageroll/Elite/cabbageroll_Elite_gather",
        cabbageroll_Elite_ground_hit = "Creature/cabbageroll/Elite/cabbageroll_Elite_ground_hit",
        cabbageroll_Elite_hit = "Creature/cabbageroll/Elite/cabbageroll_Elite_hit",
        cabbageroll_Elite_knockdown = "Creature/cabbageroll/Elite/cabbageroll_Elite_knockdown",
        cabbageroll_Elite_spin_LP = "Creature/cabbageroll/Elite/cabbageroll_Elite_spin_LP",
        cabbageroll_Elite_spin_pst = "Creature/cabbageroll/Elite/cabbageroll_Elite_spin_pst",
        cabbageroll_Elite_spin_start = "Creature/cabbageroll/Elite/cabbageroll_Elite_spin_start",
        cabbageroll_Elite_spin_tell = "Creature/cabbageroll/Elite/cabbageroll_Elite_spin_tell",
        cabbageroll_Elite_twirl = "Creature/cabbageroll/Elite/cabbageroll_Elite_twirl",
        cabbageroll_Elite_twirl_LP = "Creature/cabbageroll/Elite/cabbageroll_Elite_twirl_LP",
        cabbageroll_Elite_VO = "Creature/cabbageroll/Elite/cabbageroll_Elite_VO",
        cabbageroll_Elite_whoosh = "Creature/cabbageroll/Elite/cabbageroll_Elite_whoosh",
        cabbageroll_footstep = "Creature/cabbageroll/Standard/cabbageroll_footstep",
        cabbageroll_gather = "Creature/cabbageroll/Standard/cabbageroll_gather",
        cabbageroll_ground_hit = "Creature/cabbageroll/Standard/cabbageroll_ground_hit",
        cabbageroll_hit = "Creature/cabbageroll/Standard/cabbageroll_hit",
        cabbageroll_hit_normal = "Creature/cabbageroll/Standard/cabbageroll_hit_normal",
        cabbageroll_knockdown = "Creature/cabbageroll/Standard/cabbageroll_knockdown",
        cabbageroll_knockdown_norm = "Creature/cabbageroll/Standard/cabbageroll_knockdown_norm",
        cabbageroll_roll_hit = "Creature/cabbageroll/Standard/cabbageroll_roll_hit",
        cabbageroll_roll_vo = "Creature/cabbageroll/Standard/cabbageroll_roll_vo",
        cabbageroll_taunt = "Creature/cabbageroll/Standard/cabbageroll_taunt",
        cabbageroll_twirl = "Creature/cabbageroll/Standard/cabbageroll_twirl",
        cabbageroll_twirl_LP = "Creature/cabbageroll/Standard/cabbageroll_twirl_LP",
        cabbageroll_VO = "Creature/cabbageroll/Standard/cabbageroll_VO",
        cabbageroll_VO_pitched = "Creature/cabbageroll/Standard/cabbageroll_VO_pitched",
        cabbageroll_whoosh = "Creature/cabbageroll/Standard/cabbageroll_whoosh",
        Cannon_ammoCounter = "Player/Weapon/Cannon/Cannon_ammoCounter",
        Cannon_ammo_fall = "Player/Weapon/Cannon/reload/Cannon_ammo_fall",
        Cannon_backfire_hold_LP = "Player/Weapon/Cannon/backfire/Cannon_backfire_hold_LP",
        Cannon_backfire_load = "Player/Weapon/Cannon/backfire/Cannon_backfire_load",
        Cannon_backfire_shoot_medium = "Player/Weapon/Cannon/backfire/Cannon_backfire_shoot_medium",
        Cannon_backfire_shoot_strong = "Player/Weapon/Cannon/backfire/Cannon_backfire_shoot_strong",
        Cannon_backfire_shoot_weak = "Player/Weapon/Cannon/backfire/Cannon_backfire_shoot_weak",
        Cannon_catch = "Player/Weapon/Cannon/mvmt/Cannon_catch",
        Cannon_drop = "Player/Weapon/Cannon/mvmt/Cannon_drop",
        Cannon_empty = "Player/Weapon/Cannon/mvmt/Cannon_empty",
        Cannon_fall = "Player/Weapon/Cannon/mvmt/Cannon_fall",
        Cannon_grab = "Player/Weapon/Cannon/mvmt/Cannon_grab",
        Cannon_latch = "Player/Weapon/Cannon/mvmt/Cannon_latch",
        Cannon_mortar_aim_LP = "Player/Weapon/Cannon/mortar/Cannon_mortar_aim_LP",
        Cannon_Mortar_Explode_Counter = "Player/Weapon/Cannon/mortar/Cannon_Mortar_Explode_Counter",
        Cannon_Mortar_Explode_Counter_Focus = "Player/Weapon/Cannon/mortar/Cannon_Mortar_Explode_Counter_Focus",
        Cannon_Mortar_Explode_Impact = "Player/Weapon/Cannon/mortar/Cannon_Mortar_Explode_Impact",
        Cannon_Mortar_Explode_Impact_Focus = "Player/Weapon/Cannon/mortar/Cannon_Mortar_Explode_Impact_Focus",
        Cannon_mortar_launch_fire_scatterer = "Player/Weapon/Cannon/mortar/Cannon_mortar_launch_fire_scatterer",
        Cannon_mortar_launch_medium = "Player/Weapon/Cannon/mortar/launch/Cannon_mortar_launch_medium",
        Cannon_mortar_launch_strong = "Player/Weapon/Cannon/mortar/launch/Cannon_mortar_launch_strong",
        Cannon_mortar_launch_tube = "Player/Weapon/Cannon/mortar/launch/Cannon_mortar_launch_tube",
        Cannon_mortar_launch_weak = "Player/Weapon/Cannon/mortar/launch/Cannon_mortar_launch_weak",
        Cannon_mortar_travel = "Player/Weapon/Cannon/mortar/Cannon_mortar_travel",
        Cannon_noammo = "Player/Weapon/Cannon/Cannon_noammo",
        Cannon_pickup = "Player/Weapon/Cannon/mvmt/Cannon_pickup",
        Cannon_plant = "Player/Weapon/Cannon/mvmt/Cannon_plant",
        Cannon_plant_pickup = "Player/Weapon/Cannon/mvmt/Cannon_plant_pickup",
        Cannon_pull = "Player/Weapon/Cannon/mvmt/Cannon_pull",
        Cannon_pull_back = "Player/Weapon/Cannon/mvmt/Cannon_pull_back",
        Cannon_reload_full = "Player/Weapon/Cannon/reload/Cannon_reload_full",
        Cannon_reload_partial_end = "Player/Weapon/Cannon/reload/Cannon_reload_partial_end",
        Cannon_reload_partial_start = "Player/Weapon/Cannon/reload/Cannon_reload_partial_start",
        Cannon_run = "Player/Weapon/Cannon/mvmt/Cannon_run",
        Cannon_Sheathe = "Player/Weapon/Cannon/mvmt/Cannon_Sheathe",
        Cannon_shockwave_hold_LP = "Player/Weapon/Cannon/shockwave/Cannon_shockwave_hold_LP",
        Cannon_shockwave_plug = "Player/Weapon/Cannon/shockwave/Cannon_shockwave_plug",
        Cannon_shockwave_shoot_medium = "Player/Weapon/Cannon/shockwave/Cannon_shockwave_shoot_medium",
        Cannon_shockwave_shoot_strong = "Player/Weapon/Cannon/shockwave/Cannon_shockwave_shoot_strong",
        Cannon_shockwave_shoot_weak = "Player/Weapon/Cannon/shockwave/Cannon_shockwave_shoot_weak",
        Cannon_shoot_blast = "Player/Weapon/Cannon/shoot/Cannon_shoot_blast",
        Cannon_shoot_heavy = "Player/Weapon/Cannon/shoot/Cannon_shoot_heavy",
        Cannon_shoot_light = "Player/Weapon/Cannon/shoot/Cannon_shoot_light",
        Cannon_shoot_projectile_travel = "Player/Weapon/Cannon/shoot/Cannon_shoot_projectile_travel",
        Cannon_shoot_projectile_travel_pop = "Player/Weapon/Cannon/shoot/Cannon_shoot_projectile_travel_pop",
        Cannon_shoot_quickrise = "Player/Weapon/Cannon/shoot/Cannon_shoot_quickrise",
        Cannon_slip = "Player/Weapon/Cannon/mvmt/Cannon_slip",
        Cannon_toss = "Player/Weapon/Cannon/mvmt/Cannon_toss",
        Cannon_Unsheathe = "Player/Weapon/Cannon/mvmt/Cannon_Unsheathe",
        Cannon_whoosh = "Player/Weapon/Cannon/mvmt/Cannon_whoosh",
        Cleaver_impact = "Player/Weapon/Cleaver/Cleaver_impact",
        Cleaver_swing_horiz = "Player/Weapon/Cleaver/Cleaver_swing_horiz",
        Cleaver_swing_vert = "Player/Weapon/Cleaver/Cleaver_swing_vert",
        cobblestone_boss = "Level/Tile_Surface/cobblestone_boss",
        cobblestone_large = "Level/Tile_Surface/cobblestone_large",
        cobblestone_medium = "Level/Tile_Surface/cobblestone_medium",
        cobblestone_small = "Level/Tile_Surface/cobblestone_small",
        coinFlip_in = "FX/coinFlip/coinFlip_in",
        coinFlip_land = "FX/coinFlip/coinFlip_land",
        coinFlip_land_fail = "FX/coinFlip/coinFlip_land_fail",
        coinFlip_land_success = "FX/coinFlip/coinFlip_land_success",
        coinFlip_out = "FX/coinFlip/coinFlip_out",
        coinFlip_toss = "FX/coinFlip/coinFlip_toss",
        coinFlip_whoosh = "FX/coinFlip/coinFlip_whoosh",
        corestone_accept = "Item/corestone/corestone_accept",
        corestone_appear_many = "Item/corestone/corestone_appear_many",
        corestone_appear_tone = "Item/corestone/corestone_appear_tone",
        corestone_appear_x2 = "Item/corestone/corestone_appear_x2",
        corestone_converter_deposit = "_newForEarlyAccess/corestone_converter_deposit",
        corestone_converter_idle_LP = "_newForEarlyAccess/corestone_converter_idle_LP",
        corestone_converter_present = "_newForEarlyAccess/corestone_converter_present",
        corestone_idle_LP = "Item/corestone/corestone_idle_LP",
        craft_new_armour = "UI/Forge/craft_new_armour",
        creature_explode = "Creature/death_creature_explode/creature_explode",
        creature_explode_large = "Creature/death_creature_explode/creature_explode_large",
        creature_explode_small = "Creature/death_creature_explode/creature_explode_small",
        creature_template_8 = "Creature/beets/creature_template 8",
        creature_template_9 = "Creature/beets/creature_template 9",
        Crit_blunt = "FX/Crits/Crit_blunt",
        Crit_pierce = "FX/Crits/Crit_pierce",
        Crit_skill = "FX/Crits/Crit_skill",
        Crit_throwstone = "FX/Hits/Skill/Crit_throwstone",
        Cutscene_FadeUpFromBlack = "Meta/Cutscene_FadeUpFromBlack",
        despawn_melee = "Creature/minions/despawn_melee",
        despawn_ranged = "Creature/minions/despawn_ranged",
        Destructible_konjur = "Props/Destructible_konjur",
        Destructible_rock = "Props/Destructible_rock",
        Destructible_Stalactite = "Props/Destructible_Stalactite",
        Destructible_Stalactite_Drop_Impact = "Props/Destructible_Stalactite_Drop_Impact",
        Destructible_Stalactite_Drop_Impact_large = "Props/Destructible_Stalactite_Drop_Impact_large",
        Destructible_Stalactite_Fall = "Props/Destructible_Stalactite_Fall",
        Destructible_Stalactite_low_rumble = "Props/Destructible_Stalactite_low_rumble",
        Destructible_Stalactite_snap = "Props/Destructible_Stalactite_snap",
        Destructible_wood = "Props/Destructible_wood",
        Dirt_bodyfall = "Player/Movement/Dirt/Dirt_bodyfall",
        dirt_boss = "Level/Tile_Surface/dirt_boss",
        Dirt_hand = "Player/Movement/Dirt/Dirt_hand",
        Dirt_jump = "Player/Movement/Dirt/Dirt_jump",
        Dirt_jump_heavy = "Player/Movement/Dirt/Dirt_jump_heavy",
        Dirt_land = "Player/Movement/Dirt/Dirt_land",
        dirt_large = "Level/Tile_Surface/dirt_large",
        dirt_medium = "Level/Tile_Surface/dirt_medium",
        Dirt_run = "Player/Movement/Dirt/Dirt_run",
        Dirt_run_stop = "Player/Movement/Dirt/Dirt_run_stop",
        Dirt_slide = "Player/Movement/Dirt/Dirt_slide",
        Dirt_slump = "Player/Movement/Dirt/Dirt_slump",
        dirt_small = "Level/Tile_Surface/dirt_small",
        Dirt_walk = "Player/Movement/Dirt/Dirt_walk",
        dungeonSelectionScreen_hide = "UI/screenHideShow/dungeonSelectionScreen_hide",
        dungeonSelectionScreen_show = "UI/screenHideShow/dungeonSelectionScreen_show",
        dungeonSelectScreen_locationAppear = "_newForEarlyAccess/dungeonSelectScreen/dungeonSelectScreen_locationAppear",
        dungeonSelectScreen_panelSlide = "_newForEarlyAccess/dungeonSelectScreen/dungeonSelectScreen_panelSlide",
        earthquake_low_rumble_LP = "FX/earthquake_low_rumble_LP",
        emoteRing_hide = "UI/emoteRing/emoteRing_hide",
        emoteRing_hover = "UI/emoteRing/emoteRing_hover",
        emoteRing_select = "UI/emoteRing/emoteRing_select",
        emoteRing_show = "UI/emoteRing/emoteRing_show",
        emoteRing_toggle = "UI/emoteRing/emoteRing_toggle",
        Emote_Amphibee_Bubbles = "Player/Emotes/SFX/Emote_Amphibee_Bubbles",
        Emote_Amphibee_Pop = "Player/Emotes/SFX/Emote_Amphibee_Pop",
        Emote_Bandicoot_Snicker = "Player/Emotes/SFX/Emote_Bandicoot_Snicker",
        Emote_Bonion_Call_Cabbageroll = "Player/Emotes/SFX/Emote_Bonion_Call_Cabbageroll",
        Emote_Cannon = "Player/Emotes/SFX/Emote_Cannon",
        Emote_ding = "Player/Emotes/SFX/Emote_ding",
        Emote_Gourdo_Face_Bash = "Player/Emotes/SFX/Emote_Gourdo_Face_Bash",
        Emote_Hammer = "Player/Emotes/SFX/Emote_Hammer",
        Emote_Kiss = "Player/Emotes/SFX/Emote_Kiss",
        Emote_mammimal = "Player/Emotes/SFX/Emote_mammimal",
        Emote_Mvmt_lg = "Player/Emotes/Mvmt/Emote_Mvmt_lg",
        Emote_Mvmt_med = "Player/Emotes/Mvmt/Emote_Mvmt_med",
        Emote_Mvmt_sm = "Player/Emotes/Mvmt/Emote_Mvmt_sm",
        Emote_Ogre_dash_01 = "Player/Emotes/Mvmt/Emote_Ogre_dash_01",
        Emote_Pole_Arm = "Player/Emotes/SFX/Emote_Pole_Arm",
        Emote_shotput = "Player/Emotes/SFX/Emote_shotput",
        Emote_shout = "Player/Emotes/SFX/Emote_shout",
        Emote_Smooch = "Player/Emotes/SFX/Emote_Smooch",
        Emote_template_8 = "Player/Emotes/SFX/Emote_template 8",
        Emote_template_9 = "Player/Emotes/SFX/Emote_template 9",
        Emote_totolili = "Player/Emotes/SFX/Emote_totolili",
        Emote_VO_03 = "Player/Emotes/Voice/Emote_VO_03",
        Emote_VO_04 = "Player/Emotes/Voice/Emote_VO_04",
        Emote_VO_05 = "Player/Emotes/Voice/Emote_VO_05",
        Emote_VO_fistPump_01 = "Player/Emotes/Voice/Emote_VO_fistPump_01",
        Emote_VO_fistPump_02 = "Player/Emotes/Voice/Emote_VO_fistPump_02",
        Emote_VO_pant_exhale = "Player/Emotes/Voice/Emote_VO_pant_exhale",
        Emote_VO_pant_inhale = "Player/Emotes/Voice/Emote_VO_pant_inhale",
        Emote_VO_shout = "Player/Emotes/Voice/Emote_VO_shout",
        Emote_Whistle = "Player/Emotes/SFX/Emote_Whistle",
        endOfRun_loot_widget_show = "UI/EndOfRun/endOfRun_loot_widget_show",
        endOfRun_mastery_levelUp = "UI/Mastery/endOfRun_mastery_levelUp",
        endOfRun_mastery_meter_show = "UI/Mastery/endOfRun_mastery_meter_show",
        endOfRun_mastery_XP_LP = "UI/Mastery/endOfRun_mastery_XP_LP",
        endOfRun_mastery_XP_tick = "UI/Mastery/endOfRun_mastery_XP_tick",
        endOfRun_rollDown = "UI/EndOfRun/endOfRun_rollDown",
        endOfRun_rollUp = "UI/EndOfRun/endOfRun_rollUp",
        endOfRun_XP_levelUp = "UI/EndOfRun/endOfRun_XP_levelUp",
        endOfRun_XP_tick_LP = "UI/EndOfRun/endOfRun_XP_tick_LP",
        equip_new_armour = "UI/Forge/equip_new_armour",
        error_bump = "UI/_defaults/error_bump",
        eyev_battlecry = "Creature/eyev/eyev_battlecry",
        eyev_bodyfall = "Creature/eyev/eyev_bodyfall",
        eyev_close = "Creature/eyev/eyev_close",
        eyev_death = "Creature/eyev/eyev_death",
        eyev_evade = "Creature/eyev/eyev_evade",
        eyev_knockdown = "Creature/eyev/eyev_knockdown",
        eyev_knockdown_getup = "Creature/eyev/eyev_knockdown_getup",
        eyev_laugh = "Creature/eyev/eyev_laugh",
        eyev_move_1 = "Creature/eyev/eyev_move_1",
        eyev_move_2 = "Creature/eyev/eyev_move_2",
        eyev_move_fast = "Creature/eyev/eyev_move_fast",
        eyev_move_fly = "Creature/eyev/eyev_move_fly",
        eyev_pierce = "Creature/eyev/eyev_pierce",
        eyev_razor_leaf_LP = "Creature/eyev/eyev_razor_leaf_LP",
        eyev_spin = "Creature/eyev/eyev_spin",
        eyev_tell = "Creature/eyev/eyev_tell",
        Flicker_Hammer = "FX/Flicker/Flicker_Hammer",
        floracrane_bodyfall = "Creature/floracrane/floracrane_bodyfall",
        floracrane_death = "Creature/floracrane/floracrane_death",
        floracrane_dive = "Creature/floracrane/floracrane_dive",
        floracrane_dive_hit = "Creature/floracrane/floracrane_dive_hit",
        floracrane_elite_death = "Creature/floracrane/floracrane_elite_death",
        floracrane_flurry = "Creature/floracrane/floracrane_flurry",
        floracrane_foley = "Creature/floracrane/floracrane_foley",
        floracrane_footstep = "Creature/floracrane/floracrane_footstep",
        floracrane_hit = "Creature/floracrane/floracrane_hit",
        floracrane_kick = "Creature/floracrane/floracrane_kick",
        floracrane_knockdown = "Creature/floracrane/floracrane_knockdown",
        floracrane_scrape = "Creature/floracrane/floracrane_scrape",
        floracrane_spear = "Creature/floracrane/floracrane_spear",
        floracrane_spinning = "Creature/floracrane/floracrane_spinning",
        floracrane_spinning_LP = "Creature/floracrane/floracrane_spinning_LP",
        floracrane_spinning_multi = "Creature/floracrane/floracrane_spinning_multi",
        floracrane_spinning_pre = "Creature/floracrane/floracrane_spinning_pre",
        floracrane_spinning_pst = "Creature/floracrane/floracrane_spinning_pst",
        floracrane_v01 = "Creature/floracrane/floracrane_v01",
        floracrane_v02 = "Creature/floracrane/floracrane_v02",
        floracrane_vo_short = "Creature/floracrane/floracrane_vo_short",
        floracrane_wings = "Creature/floracrane/floracrane_wings",
        flying_machine = "Props/Flying machine/flying_machine",
        flying_machine_claw_closed = "Props/Flying machine/flying_machine_claw_closed",
        flying_machine_claw_open = "Props/Flying machine/flying_machine_claw_open",
        flying_machine_pick_up_x = "Props/Flying machine/flying_machine_pick_up_x",
        flying_machine_Ratchet_LP = "Props/Flying machine/flying_machine_Ratchet_LP",
        flying_machine_short = "Props/Flying machine/flying_machine_short",
        flying_machine_spin_LP = "Props/Flying machine/flying_machine_spin_LP",
        flying_machine_spin_pre = "Props/Flying machine/flying_machine_spin_pre",
        flying_machine_spin_pst = "Props/Flying machine/flying_machine_spin_pst",
        Focus_hit_blunt = "FX/Hits/Focus Hits/Focus_hit_blunt",
        Focus_hit_cannon = "FX/Hits/Focus Hits/Focus_hit_cannon",
        Focus_hit_cannon_mortar_Scatterer = "FX/Hits/Focus Hits/Focus_hit_cannon_mortar_Scatterer",
        Focus_hit_pierce = "FX/Hits/Focus Hits/Focus_hit_pierce",
        Focus_hit_shotput = "FX/Hits/Focus Hits/Focus_hit_shotput",
        Foley_cloth = "NPC/Foley/Foley_cloth",
        Foley_leather = "NPC/Foley/Foley_leather",
        Foley_Metal = "NPC/Foley/Foley_Metal",
        foodScreen_hide = "UI/screenHideShow/foodScreen_hide",
        foodScreen_show = "UI/screenHideShow/foodScreen_show",
        footstep_base_layer = "Creature/basic_footstep/footstep_base_layer",
        footstep_dirt_boss = "Creature/basic_footstep/footstep_dirt_boss",
        footstep_dirt_large = "Creature/basic_footstep/footstep_dirt_large",
        footstep_dirt_medium = "Creature/basic_footstep/footstep_dirt_medium",
        footstep_dirt_small = "Creature/basic_footstep/footstep_dirt_small",
        forestPath_open = "Level/StartingForest/forestPath_open",
        forestPath_open_magic = "Level/StartingForest/forestPath_open_magic",
        forestPath_open_moan = "Level/StartingForest/forestPath_open_moan",
        forgeArmorScreen_hide = "UI/screenHideShow/forgeArmorScreen_hide",
        forgeArmorScreen_show = "UI/screenHideShow/forgeArmorScreen_show",
        forgeWeaponScreen_hide = "UI/screenHideShow/forgeWeaponScreen_hide",
        forgeWeaponScreen_show = "UI/screenHideShow/forgeWeaponScreen_show",
        FullscreenOverlay_Instant_LP = "Meta/Overlays/FullscreenOverlay_Instant_LP",
        FullscreenOverlay_LP = "Meta/Overlays/FullscreenOverlay_LP",
        fuzz_boss = "Level/Tile_Surface/fuzz_boss",
        fuzz_large = "Level/Tile_Surface/fuzz_large",
        fuzz_medium = "Level/Tile_Surface/fuzz_medium",
        fuzz_small = "Level/Tile_Surface/fuzz_small",
        fx_heal_burst = "FX/Heal/fx_heal_burst",
        fx_heal_burst_universal = "FX/Heal/fx_heal_burst_universal",
        fx_heal_revive_LP = "FX/Heal/fx_heal_revive_LP",
        gateIndicator_active = "Props/gateIndicator/gateIndicator_active",
        gateIndicator_fade = "Props/gateIndicator/gateIndicator_fade",
        gateIndicator_particles_LP = "Props/gateIndicator/gateIndicator_particles_LP",
        Glint_Hammer = "FX/Glint/Glint_Hammer",
        Glint_Hammer_GolfSwing = "FX/Glint/Glint_Hammer_GolfSwing",
        Glint_Hammer_Overhead = "FX/Glint/Glint_Hammer_Overhead",
        Glint_pre = "FX/Glint/Glint_pre",
        gnarlic_be1 = "Creature/gnarlic/gnarlic_be1",
        gnarlic_bodyfall = "Creature/gnarlic/gnarlic_bodyfall",
        gnarlic_breath = "Creature/gnarlic/gnarlic_breath",
        gnarlic_death = "Creature/gnarlic/gnarlic_death",
        gnarlic_elite_slam = "Creature/gnarlic/gnarlic_elite_slam",
        gnarlic_foley = "Creature/gnarlic/gnarlic_foley",
        gnarlic_footstep = "Creature/gnarlic/gnarlic_footstep",
        gnarlic_hit = "Creature/gnarlic/gnarlic_hit",
        gnarlic_knockdown = "Creature/gnarlic/gnarlic_knockdown",
        gnarlic_poke_LP = "Creature/gnarlic/gnarlic_poke_LP",
        gnarlic_poke_stop = "Creature/gnarlic/gnarlic_poke_stop",
        gnarlic_poke_vo_run = "Creature/gnarlic/gnarlic_poke_vo_run",
        gnarlic_poke_yell = "Creature/gnarlic/gnarlic_poke_yell",
        gnarlic_spawn = "Creature/gnarlic/gnarlic_spawn",
        gourdo_breath = "Creature/gourdo/Voice/gourdo_breath",
        gourdo_buff_hold = "Creature/gourdo/Voice/gourdo_buff_hold",
        gourdo_buttslam_vo = "Creature/gourdo/Voice/gourdo_buttslam_vo",
        gourdo_butt_slam_jump = "Creature/gourdo/Voice/gourdo_butt_slam_jump",
        gourdo_butt_slam_land = "Creature/gourdo/Movement/gourdo_butt_slam_land",
        gourdo_chest_pound = "Creature/gourdo/Movement/gourdo_chest_pound",
        gourdo_death = "Creature/gourdo/Voice/gourdo_death",
        gourdo_foley1 = "Creature/gourdo/Movement/gourdo_foley1",
        gourdo_footstep = "Creature/gourdo/Movement/gourdo_footstep",
        gourdo_get_up = "Creature/gourdo/Voice/gourdo_get_up",
        gourdo_hit = "Creature/gourdo/Voice/gourdo_hit",
        gourdo_idle = "Creature/gourdo/Voice/gourdo_idle",
        gourdo_knockdown = "Creature/gourdo/Voice/gourdo_knockdown",
        gourdo_land = "Creature/gourdo/Movement/gourdo_land",
        gourdo_punch = "Creature/gourdo/Movement/gourdo_punch",
        gourdo_seed_death = "Creature/gourdo/Weapon/gourdo_seed_death",
        gourdo_seed_eyeball = "Creature/gourdo/Weapon/gourdo_seed_eyeball",
        gourdo_seed_heal = "Creature/gourdo/Weapon/gourdo_seed_heal",
        gourdo_seed_land = "Creature/gourdo/Weapon/gourdo_seed_land",
        gourdo_shoot = "Creature/gourdo/Voice/gourdo_shoot",
        gourdo_spawn = "Creature/gourdo/Movement/gourdo_spawn",
        gourdo_takedown_pre = "Creature/gourdo/Voice/gourdo_takedown_pre",
        gourdo_taunt_vo = "Creature/gourdo/Voice/gourdo_taunt_vo",
        grass_boss = "Level/Tile_Surface/grass_boss",
        grass_large = "Level/Tile_Surface/grass_large",
        grass_medium = "Level/Tile_Surface/grass_medium",
        grass_small = "Level/Tile_Surface/grass_small",
        groak_bite = "Creature/groak/groak_bite",
        groak_bodyfall = "Creature/groak/groak_bodyfall",
        groak_burrow = "Creature/groak/groak_burrow",
        groak_chest_hit = "Creature/groak/groak_chest_hit",
        groak_chew = "Creature/groak/groak_chew",
        groak_chew_2 = "Creature/groak/groak_chew_2",
        groak_death = "Creature/groak/groak_death",
        groak_dig = "Creature/groak/groak_dig",
        groak_flap = "Creature/groak/groak_flap",
        groak_footstep_big = "Creature/groak/groak_footstep_big",
        groak_footstep_small = "Creature/groak/groak_footstep_small",
        groak_ground_hit = "Creature/groak/groak_ground_hit",
        groak_ground_hit_double = "Creature/groak/groak_ground_hit_double",
        groak_ground_hit_EQ = "Creature/groak/groak_ground_hit_EQ",
        groak_grunt = "Creature/groak/groak_grunt",
        groak_grunt_2 = "Creature/groak/groak_grunt_2",
        groak_hit = "Creature/groak/groak_hit",
        groak_knockdown = "Creature/groak/groak_knockdown",
        groak_no_swallow = "Creature/groak/groak_no_swallow",
        groak_rumble = "Creature/groak/groak_rumble",
        groak_spit_out = "Creature/groak/groak_spit_out",
        groak_suck = "Creature/groak/groak_suck",
        groak_yell = "Creature/groak/groak_yell",
        Gustree_Dodge = "Player/Power/Equipment/Gustree_Dodge",
        Gustree_Spikeball = "Player/Power/Equipment/Gustree_Spikeball",
        Hammer_atk_1 = "Player/Weapon/Hammer/Hammer_atk_1",
        Hammer_atk_2 = "Player/Weapon/Hammer/Hammer_atk_2",
        Hammer_atk_3 = "Player/Weapon/Hammer/Hammer_atk_3",
        Hammer_atk_air_focus_whoosh = "FX/Whoosh/Hammer/Hammer_atk_air_focus_whoosh",
        Hammer_atk_charge_focus_whoosh = "FX/Whoosh/Hammer/Hammer_atk_charge_focus_whoosh",
        Hammer_atk_fade = "Player/Weapon/Hammer/Hammer_atk_fade",
        Hammer_atk_overhead = "Player/Weapon/Hammer/Hammer_atk_overhead",
        Hammer_atk_overhead_alt = "Player/Weapon/Hammer/Hammer_atk_overhead_alt",
        Hammer_atk_overhead_focus_whoosh = "FX/Whoosh/Hammer/Hammer_atk_overhead_focus_whoosh",
        Hammer_atk_overhead_impact = "Player/Weapon/Hammer/Hammer_atk_overhead_impact",
        Hammer_atk_reverse = "Player/Weapon/Hammer/Hammer_atk_reverse",
        Hammer_atk_spin_focus_whoosh = "FX/Whoosh/Hammer/Hammer_atk_spin_focus_whoosh",
        Hammer_drop = "Player/Weapon/Hammer/Hammer_drop",
        Hammer_drop2 = "Player/Weapon/Hammer/Hammer_drop2",
        Hammer_ExtraHit_Whoosh = "_newForEarlyAccess/Weapon Skills/Hammer/Hammer_ExtraHit_Whoosh",
        Hammer_Sheathe = "Player/Weapon/Hammer/Hammer_Sheathe",
        Hammer_spin = "Player/Weapon/Hammer/Hammer_spin",
        Hammer_spin_pst = "Player/Weapon/Hammer/Hammer_spin_pst",
        Hammer_Unsheathe = "Player/Weapon/Hammer/Hammer_Unsheathe",
        healingFountain_drink_LP = "Props/HealingFountain/healingFountain_drink_LP",
        healingFountain_finished = "Props/HealingFountain/healingFountain_finished",
        healingFountain_LP = "Props/HealingFountain/healingFountain_LP",
        healingFountain_sip = "Props/HealingFountain/healingFountain_sip",
        Hit_acid = "FX/Hit_acid",
        Hit_ball = "FX/Hits/Weapons/shotput/Hit_ball",
        Hit_ball_tail = "FX/Hits/Weapons/shotput/Hit_ball_tail",
        Hit_BigStick_Counter = "FX/Hits/Scatterers/Hit_BigStick_Counter",
        Hit_BigStick_Explosion_Single = "FX/Hits/Scatterers/Hit_BigStick_Explosion_Single",
        Hit_BigStick_Scatterer = "FX/Hits/Scatterers/Hit_BigStick_Scatterer",
        Hit_blocked = "FX/Hits/Hit_blocked",
        Hit_blunt = "FX/Hits/Weapons/Hit_blunt",
        Hit_blunt_extra = "_newForEarlyAccess/Weapon Skills/Hammer/Hit_blunt_extra",
        Hit_blunt_heavy = "FX/Hits/Weapons/Hit_blunt_heavy",
        Hit_bonionRoll = "FX/Hits/Skill/Hit_bonionRoll",
        Hit_cannon = "FX/Hits/Weapons/cannon/Hit_cannon",
        Hit_Cannon_Mortar = "FX/Hits/Weapons/cannon/Hit_Cannon_Mortar",
        Hit_Cannon_Mortar_Scatterer = "FX/Hits/Weapons/cannon/Hit_Cannon_Mortar_Scatterer",
        Hit_cannon_tail = "FX/Hits/Weapons/cannon/Hit_cannon_tail",
        Hit_dirt = "FX/Hits/Weapons/Hit_dirt",
        Hit_enemy = "FX/Hits/Hit Player/Basic Hits/Hit_enemy",
        Hit_headbutt = "FX/Hits/Weapons/shotput/Hit_headbutt",
        Hit_pierce = "FX/Hits/Weapons/Hit_pierce",
        Hit_Pinecone_Bomb_Counter = "FX/Hits/Scatterers/Hit_Pinecone_Bomb_Counter",
        Hit_player = "FX/Hits/Hit Player/Basic Hits/Hit_player",
        Hit_player_acid = "FX/Hits/Hit Player/Basic Hits/Hit_player_acid",
        Hit_player_death = "FX/Hits/Hit Player/Hit_player_death",
        Hit_player_death_ring = "FX/Hits/Hit Player/Hit_player_death_ring",
        Hit_player_local = "FX/Hits/Hit Player/Basic Hits/Hit_player_local",
        Hit_player_lowHealth = "FX/Hits/Hit Player/Hit_player_lowHealth",
        Hit_player_remote_ally = "FX/Hits/Hit Player/Basic Hits/Hit_player_remote_ally",
        Hit_reduced = "FX/Hits/Hit_reduced",
        Hit_shotput = "FX/Hits/Weapons/shotput/Hit_shotput",
        Hit_shove = "FX/Hits/Skill/Hit_shove",
        Hit_tackle = "FX/Hits/Weapons/shotput/Hit_tackle",
        Hit_throwStone = "FX/Hits/Skill/Hit_throwStone",
        Hit_unarmed_cannon = "FX/Hits/Weapons/Hit_unarmed_cannon",
        hover = "UI/_defaults/hover",
        hover_characterCustomization = "UI/characterCustomization/hover_characterCustomization",
        hover_mainMenu = "UI/optionsScreen/hover_mainMenu",
        hover_roomBonusButton = "UI/roomBonusScreen/hover_roomBonusButton",
        hover_speechBubble = "UI/Speech/hover_speechBubble",
        input_down = "UI/_defaults/input_down",
        input_down_characterCustomization = "UI/characterCustomization/input_down_characterCustomization",
        input_down_mainMenu = "UI/optionsScreen/input_down_mainMenu",
        input_down_roomBonusButton = "UI/roomBonusScreen/input_down_roomBonusButton",
        input_up = "UI/_defaults/input_up",
        input_up_characterCustomization = "UI/characterCustomization/input_up_characterCustomization",
        input_up_mainMenu = "UI/optionsScreen/input_up_mainMenu",
        input_up_roomBonusButton_pickedKonjur = "UI/roomBonusScreen/input_up_roomBonusButton_pickedKonjur",
        input_up_roomBonusButton_pickedPower = "UI/roomBonusScreen/input_up_roomBonusButton_pickedPower",
        inventory_craft_cannon = "UI/Craft/inventory_craft_cannon",
        inventory_craft_cloth = "UI/Craft/inventory_craft_cloth",
        inventory_craft_food = "UI/Craft/inventory_craft_food",
        inventory_craft_fur = "UI/Craft/inventory_craft_fur",
        inventory_craft_grass = "UI/Craft/inventory_craft_grass",
        inventory_craft_hammer = "UI/Craft/inventory_craft_hammer",
        inventory_craft_hide = "UI/Craft/inventory_craft_hide",
        inventory_craft_leather = "UI/Craft/inventory_craft_leather",
        inventory_craft_plate = "UI/Craft/inventory_craft_plate",
        inventory_craft_polearm = "UI/Craft/inventory_craft_polearm",
        inventory_craft_potions = "UI/Craft/inventory_craft_potions",
        inventory_craft_scales = "UI/Craft/inventory_craft_scales",
        inventory_craft_shotput = "UI/Craft/inventory_craft_shotput",
        inventory_craft_squishy = "UI/Craft/inventory_craft_squishy",
        inventory_craft_tonics = "UI/Craft/inventory_craft_tonics",
        inventory_equip = "UI/Inventory/inventory_equip",
        inventory_equip_armor = "UI/Inventory/inventory_equip_armor",
        inventory_equip_cannon = "UI/Inventory/equip/inventory_equip_cannon",
        inventory_equip_cleaver = "UI/Inventory/equip/inventory_equip_cleaver",
        inventory_equip_cloth = "UI/Inventory/equip/inventory_equip_cloth",
        inventory_equip_food = "UI/Inventory/equip/inventory_equip_food",
        inventory_equip_fur = "UI/Inventory/equip/inventory_equip_fur",
        inventory_equip_grass = "UI/Inventory/equip/inventory_equip_grass",
        inventory_equip_hammer = "UI/Inventory/equip/inventory_equip_hammer",
        inventory_equip_hide = "UI/Inventory/equip/inventory_equip_hide",
        inventory_equip_leather = "UI/Inventory/equip/inventory_equip_leather",
        inventory_equip_plate = "UI/Inventory/equip/inventory_equip_plate",
        inventory_equip_polearm = "UI/Inventory/equip/inventory_equip_polearm",
        inventory_equip_potions = "UI/Inventory/equip/inventory_equip_potions",
        inventory_equip_scales = "UI/Inventory/equip/inventory_equip_scales",
        inventory_equip_shotput = "UI/Inventory/equip/inventory_equip_shotput",
        inventory_equip_squishy = "UI/Inventory/equip/inventory_equip_squishy",
        inventory_equip_tonics = "UI/Inventory/equip/inventory_equip_tonics",
        inventory_equip_weapon = "UI/Inventory/inventory_equip_weapon",
        inventory_hide = "UI/screenHideShow/inventory_hide",
        inventory_show = "UI/screenHideShow/inventory_show",
        inventory_upgrade = "UI/Inventory/inventory_upgrade",
        item_land_common = "FX/Loot/Land/item_land_common",
        item_land_epic = "FX/Loot/Land/item_land_epic",
        item_land_konjur = "FX/Loot/Land/item_land_konjur",
        item_land_legendary = "FX/Loot/Land/item_land_legendary",
        item_land_rare = "FX/Loot/Land/item_land_rare",
        item_land_uncommon = "FX/Loot/Land/item_land_uncommon",
        item_pickup = "Item/item_pickup",
        item_pickup_common = "FX/Loot/Pickup/item_pickup_common",
        item_pickup_epic = "FX/Loot/Pickup/item_pickup_epic",
        item_pickup_konjur = "FX/Loot/Pickup/item_pickup_konjur",
        item_pickup_legendary = "FX/Loot/Pickup/item_pickup_legendary",
        item_pickup_rare = "FX/Loot/Pickup/item_pickup_rare",
        item_pickup_uncommon = "FX/Loot/Pickup/item_pickup_uncommon",
        joinedTheParty = "UI/Stingers/joinedTheParty",
        Knockdown = "FX/Hits/Knockdown",
        konjurHeart_absorb = "Item/Heartstone/konjurHeart_absorb",
        konjurHeart_crazyRamp = "Item/Heartstone/konjurHeart_crazyRamp",
        konjurHeart_idle_LP = "Item/Heartstone/konjurHeart_idle_LP",
        konjurHeart_idle_shimmer = "Item/Heartstone/konjurHeart_idle_shimmer",
        konjurHeart_rattle = "Item/Heartstone/konjurHeart_rattle",
        konjurHeart_rumble = "Item/Heartstone/konjurHeart_rumble",
        konjurHeart_shatter_crystal = "Item/Heartstone/konjurHeart_shatter_crystal",
        konjurHeart_spawn_energy = "Item/Heartstone/konjurHeart_spawn_energy",
        konjurHeart_spawn_explode = "Item/Heartstone/konjurHeart_spawn_explode",
        konjurHeart_spawn_ping = "Item/Heartstone/konjurHeart_spawn_ping",
        konjur_accept = "FX/konjur_accept",
        konjur_accept_infinityGauntlet = "FX/konjur_accept_infinityGauntlet",
        konjur_blob_appear_burble = "Item/konjurBlob/konjur_blob_appear_burble",
        konjur_blob_appear_energy = "Item/konjurBlob/konjur_blob_appear_energy",
        konjur_blob_pop = "Item/konjurBlob/konjur_blob_pop",
        lastMobKilled = "UI/lastMobKilled",
        ListeningEnvironment_Headphones_LP = "Meta/ListeningEnvironment/ListeningEnvironment_Headphones_LP",
        ListeningEnvironment_Speakers_LP = "Meta/ListeningEnvironment/ListeningEnvironment_Speakers_LP",
        ListeningEnvironment_SteamDeck_LP = "Meta/ListeningEnvironment/ListeningEnvironment_SteamDeck_LP",
        loot_pop_common = "UI/Loot/loot_pop_common",
        loot_pop_epic = "UI/Loot/loot_pop_epic",
        loot_pop_legendary = "UI/Loot/loot_pop_legendary",
        loot_pop_rare = "UI/Loot/loot_pop_rare",
        loot_pop_uncommon = "UI/Loot/loot_pop_uncommon",
        lucky = "lucky",
        megatreemon_death_eye = "Creature/megatreemon/Movement/megatreemon_death_eye",
        megatreemon_death_fall = "Creature/megatreemon/Movement/megatreemon_death_fall",
        megatreemon_death_yell = "Creature/megatreemon/Voice/megatreemon_death_yell",
        megatreemon_defend = "Creature/megatreemon/Voice/megatreemon_defend",
        megatreemon_defend_pre = "Creature/megatreemon/Voice/megatreemon_defend_pre",
        megatreemon_eye_move = "Creature/megatreemon/Movement/megatreemon_eye_move",
        megatreemon_fail = "Creature/megatreemon/Voice/megatreemon_fail",
        megatreemon_fail_loop_pre = "Creature/megatreemon/Voice/megatreemon_fail_loop_pre",
        megatreemon_foley = "Creature/megatreemon/Movement/megatreemon_foley",
        megatreemon_hit = "Creature/megatreemon/Voice/megatreemon_hit",
        megatreemon_intro_foley = "Creature/megatreemon/Intro/megatreemon_intro_foley",
        megatreemon_intro_roar = "Creature/megatreemon/Intro/megatreemon_intro_roar",
        megatreemon_intro_root_attack = "Creature/megatreemon/Intro/megatreemon_intro_root_attack",
        megatreemon_intro_root_pst = "Creature/megatreemon/Intro/megatreemon_intro_root_pst",
        megatreemon_intro_root_spike_intro = "Creature/megatreemon/Intro/megatreemon_intro_root_spike_intro",
        megatreemon_intro_root_spike_pre = "Creature/megatreemon/Intro/megatreemon_intro_root_spike_pre",
        megatreemon_intro_snap = "Creature/megatreemon/Intro/megatreemon_intro_snap",
        megatreemon_intro_swipe_pre = "Creature/megatreemon/Intro/megatreemon_intro_swipe_pre",
        megatreemon_pick = "Creature/megatreemon/Weapon/megatreemon_pick",
        megatreemon_roar = "Creature/megatreemon/Voice/megatreemon_roar",
        megatreemon_root_attack = "Creature/megatreemon/Weapon/megatreemon_root_attack",
        megatreemon_root_defend = "Creature/megatreemon/Movement/megatreemon_root_defend",
        megatreemon_root_pst = "Creature/megatreemon/Weapon/megatreemon_root_pst",
        megatreemon_root_rumble_LP = "Creature/megatreemon/Weapon/megatreemon_root_rumble_LP",
        megatreemon_root_rumble_short = "Creature/megatreemon/Weapon/megatreemon_root_rumble_short",
        megatreemon_root_spike_attack_warning = "Creature/megatreemon/Weapon/megatreemon_root_spike_attack_warning",
        megatreemon_root_spike_impact = "Creature/megatreemon/Weapon/megatreemon_root_spike_impact",
        megatreemon_root_spike_pre = "Creature/megatreemon/Weapon/megatreemon_root_spike_pre",
        megatreemon_snap = "Creature/megatreemon/Weapon/megatreemon_snap",
        megatreemon_swipe = "Creature/megatreemon/Weapon/megatreemon_swipe",
        megatreemon_swipe_pre = "Creature/megatreemon/Voice/megatreemon_swipe_pre",
        megatreemon_uproot_gurgle = "Creature/megatreemon/Voice/megatreemon_uproot_gurgle",
        megatreemon_uproot_warn = "Creature/megatreemon/Voice/megatreemon_uproot_warn",
        megatreemon_VO = "Creature/megatreemon/Voice/megatreemon_VO",
        megatreemon_VO_2 = "Creature/megatreemon/Voice/megatreemon_VO_2",
        Meta_TemporarilyDisableMusicFiltering = "Meta/OptionsMenu/Meta_TemporarilyDisableMusicFiltering",
        miniboss_death = "FX/miniboss_death",
        Minigame_Countdown = "FX/Minigame/Minigame_Countdown",
        Minigame_Finish = "FX/Minigame/Minigame_Finish",
        Minigame_HitStreak_Teleport = "FX/Minigame/Minigame_HitStreak_Teleport",
        minion = "Creature/minions/minion",
        minion1_land = "Creature/minions/minion1_land",
        minion2_shoot = "Creature/minions/minion2_shoot",
        minion_explode = "Creature/minions/minion_explode",
        miniTreemon_hit = "Creature/treemon/Movement/miniTreemon_hit",
        miniTreemon_release = "Creature/treemon/Movement/miniTreemon_release",
        miniTreemon_root_cancel = "Creature/treemon/Weapon/miniTreemon_root_cancel",
        miniTreemon_root_rumble = "Creature/treemon/Weapon/miniTreemon_root_rumble",
        miniTreemon_root_spike = "Creature/treemon/Weapon/miniTreemon_root_spike",
        miniTreemon_root_withdraw = "Creature/treemon/Weapon/miniTreemon_root_withdraw",
        miniTreemon_VO_hit = "Creature/treemon/Voice/miniTreemon_VO_hit",
        miniTreemon_VO_windUp = "Creature/treemon/Voice/miniTreemon_VO_windUp",
        mold_boss = "Level/Tile_Surface/mold_boss",
        mold_large = "Level/Tile_Surface/mold_large",
        mold_medium = "Level/Tile_Surface/mold_medium",
        mold_small = "Level/Tile_Surface/mold_small",
        mossquito_acid = "Creature/mossquito/mossquito_acid",
        mossquito_acid_hold = "Creature/mossquito/mossquito_acid_hold",
        mossquito_bodyfall = "Creature/mossquito/mossquito_bodyfall",
        mossquito_dash = "Creature/mossquito/mossquito_dash",
        mossquito_death = "Creature/mossquito/mossquito_death",
        mossquito_flying_LP = "Creature/mossquito/mossquito_flying_LP",
        mossquito_hit = "Creature/mossquito/mossquito_hit",
        mossquito_hit_elite = "Creature/mossquito/mossquito_hit_elite",
        mossquito_knockdown = "Creature/mossquito/mossquito_knockdown",
        mossquito_pierce = "Creature/mossquito/mossquito_pierce",
        mossquito_pierce_elite = "Creature/mossquito/mossquito_pierce_elite",
        mossquito_pierce_elite_2 = "Creature/mossquito/mossquito_pierce_elite_2",
        mossquito_pierce_hold = "Creature/mossquito/mossquito_pierce_hold",
        mossquito_pierce_hold_elite = "Creature/mossquito/mossquito_pierce_hold_elite",
        Moss_bodyfall = "Player/Movement/moss/Moss_bodyfall",
        Moss_hand = "Player/Movement/moss/Moss_hand",
        Moss_jump = "Player/Movement/moss/Moss_jump",
        Moss_jump_heavy = "Player/Movement/moss/Moss_jump_heavy",
        Moss_land = "Player/Movement/moss/Moss_land",
        Moss_run = "Player/Movement/moss/Moss_run",
        Moss_run_stop = "Player/Movement/moss/Moss_run_stop",
        Moss_slide = "Player/Movement/moss/Moss_slide",
        Moss_slump = "Player/Movement/moss/Moss_slump",
        Moss_walk = "Player/Movement/moss/Moss_walk",
        mothball_bite = "Creature/mothball/mothball_bite",
        mothball_chatter = "Creature/mothball/mothball_chatter",
        mothball_claw = "Creature/mothball/mothball_claw",
        mothball_claw_pre = "Creature/mothball/mothball_claw_pre",
        mothball_death = "Creature/mothball/mothball_death",
        mothball_footstep = "Creature/mothball/mothball_footstep",
        mothball_hit = "Creature/mothball/mothball_hit",
        mothball_intro_footstep = "Creature/mothball/mothball_intro_footstep",
        mothball_pierce = "Creature/mothball/mothball_pierce",
        mothball_pierce_pre = "Creature/mothball/mothball_pierce_pre",
        mothball_spawn = "Creature/mothball/mothball_spawn",
        mothball_spawner_spawn = "Creature/mothball/mothball_spawner_spawn",
        mothball_spawner_spawning = "Creature/mothball/mothball_spawner_spawning",
        mothball_taunt = "Creature/mothball/mothball_taunt",
        mothball_teen_atk_2_LP = "Creature/mothball_teen/mothball_teen_atk_2_LP",
        mothball_teen_atk_LP = "Creature/mothball_teen/mothball_teen_atk_LP",
        mothball_teen_attack_pre = "Creature/mothball_teen/mothball_teen_attack_pre",
        mothball_teen_death = "Creature/mothball_teen/mothball_teen_death",
        mothball_teen_escape = "Creature/mothball_teen/mothball_teen_escape",
        mothball_teen_footstep = "Creature/mothball_teen/mothball_teen_footstep",
        mothball_teen_hit = "Creature/mothball_teen/mothball_teen_hit",
        mothball_teen_knockdown = "Creature/mothball_teen/mothball_teen_knockdown",
        mothball_teen_spawn = "Creature/mothball_teen/mothball_teen_spawn",
        mothball_teen_taunt = "Creature/mothball_teen/mothball_teen_taunt",
        mothball_whoosh = "Creature/mothball/mothball_whoosh",
        mothball_whoosh_faster = "Creature/mothball/mothball_whoosh_faster",
        Mus_Bandicoot_DashStinger = "Music/Boss/Bandicoot/Mus_Bandicoot_DashStinger",
        mus_Bandicoot_intro = "Music/Boss/Bandicoot/mus_Bandicoot_intro",
        Mus_Bandicoot_LP = "Music/Boss/Bandicoot/Mus_Bandicoot_LP",
        Mus_Bandicoot_PillarRevealStinger = "Music/Boss/Bandicoot/Mus_Bandicoot_PillarRevealStinger",
        mus_BandiForest_LP = "Music/Dungeons/mus_BandiForest_LP",
        mus_CharacterCreation_LP = "Music/Menus/mus_CharacterCreation_LP",
        mus_Cooking = "Music/Rooms/mus_Cooking",
        mus_CookingLevel_LP = "Music/Rooms/mus_CookingLevel_LP",
        mus_Death_LP = "Music/mus_Death_LP",
        Mus_joinedTheParty_Stinger = "Music/Stingers/Mus_joinedTheParty_Stinger",
        mus_KonjineerLevel_LP = "Music/Rooms/mus_KonjineerLevel_LP",
        Mus_levelUp_Stinger = "Music/Stingers/Mus_levelUp_Stinger",
        mus_MagitekRoom_LP = "Music/Rooms/mus_MagitekRoom_LP",
        mus_Market_LP = "Music/Rooms/mus_Market_LP",
        mus_megatreemon_LP = "Music/Boss/Megatreemon/mus_megatreemon_LP",
        mus_MinigameLevel_LP = "Music/Minigame/mus_MinigameLevel_LP",
        Mus_miscStinger = "Music/Stingers/Mus_miscStinger",
        mus_MysteriousWandererLevel_LP = "Music/Rooms/mus_MysteriousWandererLevel_LP",
        Mus_mysteryEncounter_Stinger = "Music/Stingers/Mus_mysteryEncounter_Stinger",
        mus_OwlitzerForest_LP = "Music/Dungeons/OwlitzerForest/mus_OwlitzerForest_LP",
        mus_OwlitzerForest_Miniboss_Intro = "Music/Dungeons/OwlitzerForest/mus_OwlitzerForest_Miniboss_Intro",
        mus_OwlitzerForest_Miniboss_LP = "Music/Dungeons/OwlitzerForest/mus_OwlitzerForest_Miniboss_LP",
        mus_OwlitzerForest_Miniboss_Victory = "Music/Dungeons/OwlitzerForest/mus_OwlitzerForest_Miniboss_Victory",
        Mus_Owlitzer_intro = "Music/Boss/Owlitzer/Mus_Owlitzer_intro",
        Mus_Owlitzer_LP = "Music/Boss/Owlitzer/Mus_Owlitzer_LP",
        Mus_Owlitzer_SwoopStinger_Dive = "Music/Boss/Owlitzer/Mus_Owlitzer_SwoopStinger_Dive",
        Mus_potionRefill_Stinger = "Music/Stingers/Mus_potionRefill_Stinger",
        Mus_Quest_BossFanfare_Stinger = "Music/Stingers/Mus_Quest_BossFanfare_Stinger",
        mus_Slideshow_LP = "Music/Menus/mus_Slideshow_LP",
        mus_Slideshow_Sectioned_LP = "Music/Menus/mus_Slideshow_Sectioned_LP",
        mus_SnakeOil_LP = "Music/Rooms/mus_SnakeOil_LP",
        mus_StartingForest_LP = "Music/Dungeons/StartingForest/mus_StartingForest_LP",
        mus_StartingForest_Miniboss_Intro = "Music/Dungeons/StartingForest/mus_StartingForest_Miniboss_Intro",
        mus_StartingForest_Miniboss_LP = "Music/Dungeons/StartingForest/mus_StartingForest_Miniboss_LP",
        mus_StartingForest_Miniboss_Victory = "Music/Dungeons/StartingForest/mus_StartingForest_Miniboss_Victory",
        mus_Swamp_LP = "Music/Dungeons/Swamp/mus_Swamp_LP",
        mus_Swamp_Miniboss_Intro = "Music/Dungeons/Swamp/mus_Swamp_Miniboss_Intro",
        mus_Swamp_Miniboss_LP = "Music/Dungeons/Swamp/mus_Swamp_Miniboss_LP",
        mus_Swamp_Miniboss_Victory = "Music/Dungeons/Swamp/mus_Swamp_Miniboss_Victory",
        mus_ThatcherSwamp_LP = "Music/Dungeons/ThatcherSwamp/mus_ThatcherSwamp_LP",
        mus_ThatcherSwamp_Miniboss_Intro = "Music/Dungeons/ThatcherSwamp/mus_ThatcherSwamp_Miniboss_Intro",
        mus_ThatcherSwamp_Miniboss_LP = "Music/Dungeons/ThatcherSwamp/mus_ThatcherSwamp_Miniboss_LP",
        mus_ThatcherSwamp_Miniboss_Victory = "Music/Dungeons/ThatcherSwamp/mus_ThatcherSwamp_Miniboss_Victory",
        Mus_Thatcher_GuitarJam = "Music/Boss/Thatcher/Mus_Thatcher_GuitarJam",
        Mus_Thatcher_Intro = "Music/Boss/Thatcher/Mus_Thatcher_Intro",
        Mus_Thatcher_Intro_GuitarSolo = "Music/Boss/Thatcher/Mus_Thatcher_Intro_GuitarSolo",
        Mus_Thatcher_LP = "Music/Boss/Thatcher/Mus_Thatcher_LP",
        mus_TitleScreen_LP = "Music/Menus/mus_TitleScreen_LP",
        mus_Town_LP = "Music/mus_Town_LP",
        Mus_weaponUnlock_Stinger = "Music/Stingers/Mus_weaponUnlock_Stinger",
        newplacebuilding = "_newForEarlyAccess/newplacebuilding",
        npc_apothecary_chat_LP = "NPC/chat/npc_apothecary_chat_LP",
        npc_armorsmith_2_chat_LP = "NPC/chat/npc_armorsmith_2_chat_LP",
        npc_armorsmith_chat_LP = "NPC/chat/npc_armorsmith_chat_LP",
        npc_blacksmith_2_chat_LP = "NPC/chat/npc_blacksmith_2_chat_LP",
        npc_blacksmith_chat_LP = "NPC/chat/npc_blacksmith_chat_LP",
        npc_blah_talk_LP = "NPC/npc_blah_talk_LP",
        Npc_clap = "NPC/Npc_clap",
        npc_clap_1 = "NPC/npc_clap_1",
        npc_clap_2 = "NPC/npc_clap_2",
        npc_cook_2_chat_LP = "NPC/chat/npc_cook_2_chat_LP",
        npc_cook_chat_LP = "NPC/chat/npc_cook_chat_LP",
        npc_dojo_master_chat_LP = "NPC/chat/npc_dojo_master_chat_LP",
        npc_iggy_chat_LP = "NPC/chat/npc_iggy_chat_LP",
        npc_konjurist_chat_LP = "NPC/chat/npc_konjurist_chat_LP",
        npc_potionmaker_dungeon_chat_LP = "NPC/chat/npc_potionmaker_dungeon_chat_LP",
        npc_refiner_chat_LP = "NPC/chat/npc_refiner_chat_LP",
        npc_scout_2_chat_LP = "NPC/chat/npc_scout_2_chat_LP",
        npc_scout_chat_LP = "NPC/chat/npc_scout_chat_LP",
        npc_specialeventhost_chat_LP = "NPC/chat/npc_specialeventhost_chat_LP",
        npc_voice_pop_LP = "NPC/npc_voice_pop_LP",
        OptionsMenu_Amb_Test_LP = "Meta/OptionsMenu/OptionsMenu_Amb_Test_LP",
        OptionsMenu_Emote_Test = "Meta/OptionsMenu/OptionsMenu_Emote_Test",
        OptionsMenu_SFXVol_Test = "Meta/OptionsMenu/OptionsMenu_SFXVol_Test",
        OptionsMenu_Voice_Test = "Meta/OptionsMenu/OptionsMenu_Voice_Test",
        owlitzer_barf = "Creature/owlitzer/owlitzer_barf",
        owlitzer_barf_pre = "Creature/owlitzer/owlitzer_barf_pre",
        owlitzer_barf_spike_land = "Traps/owlitzer_barf_spike_land",
        owlitzer_blink = "Creature/owlitzer/owlitzer_blink",
        owlitzer_death = "Creature/owlitzer/owlitzer_death",
        owlitzer_divebomb_hit = "Creature/owlitzer/owlitzer_divebomb_hit",
        owlitzer_divebomb_miss = "Creature/owlitzer/owlitzer_divebomb_miss",
        owlitzer_divebomb_pre = "Creature/owlitzer/owlitzer_divebomb_pre",
        owlitzer_divebomb_vo = "Creature/owlitzer/owlitzer_divebomb_vo",
        owlitzer_dive_bomb_warning_LP = "Creature/owlitzer/owlitzer_dive_bomb_warning_LP",
        owlitzer_eyes = "Creature/owlitzer/owlitzer_eyes",
        owlitzer_faster_move = "Creature/owlitzer/owlitzer_faster_move",
        owlitzer_fast_move = "Creature/owlitzer/owlitzer_fast_move",
        owlitzer_flyby = "Creature/owlitzer/owlitzer_flyby",
        owlitzer_flyby_LP = "Creature/owlitzer/owlitzer_flyby_LP",
        owlitzer_hairball_death = "Creature/owlitzer/owlitzer_hairball_death",
        owlitzer_hairball_spin_LP = "Creature/owlitzer/owlitzer_hairball_spin_LP",
        owlitzer_hit = "Creature/owlitzer/owlitzer_hit",
        owlitzer_intro2 = "Creature/owlitzer/owlitzer_intro2",
        owlitzer_intro_land = "Creature/owlitzer/owlitzer_intro_land",
        owlitzer_intro_vo = "Creature/owlitzer/owlitzer_intro_vo",
        owlitzer_knockdown = "Creature/owlitzer/owlitzer_knockdown",
        owlitzer_laugh = "Creature/owlitzer/owlitzer_laugh",
        owlitzer_laugh_end = "Creature/owlitzer/owlitzer_laugh_end",
        owlitzer_launch = "Creature/owlitzer/owlitzer_launch",
        owlitzer_phase = "Creature/owlitzer/owlitzer_phase",
        owlitzer_protect_hold = "Creature/owlitzer/owlitzer_protect_hold",
        owlitzer_protect_pre = "Creature/owlitzer/owlitzer_protect_pre",
        owlitzer_super_flap = "Creature/owlitzer/owlitzer_super_flap",
        owlitzer_super_flap_light = "Creature/owlitzer/owlitzer_super_flap_light",
        owlitzer_super_flap_LP = "Creature/owlitzer/owlitzer_super_flap_LP",
        owlitzer_swipe = "Creature/owlitzer/owlitzer_swipe",
        owlitzer_targetLock_LP = "Creature/owlitzer/owlitzer_targetLock_LP",
        owlitzer_tell = "Creature/owlitzer/owlitzer_tell",
        owlitzer_vo_down = "Creature/owlitzer/owlitzer_vo_down",
        owlitzer_vo_short = "Creature/owlitzer/owlitzer_vo_short",
        owlitzer_vo_up = "Creature/owlitzer/owlitzer_vo_up",
        owlitzer_whip = "Creature/owlitzer/owlitzer_whip",
        owlitzer_windgust_pre = "Creature/owlitzer/owlitzer_windgust_pre",
        owlitzer_wind_pre = "Creature/owlitzer/owlitzer_wind_pre",
        owlitzer_wings = "Creature/owlitzer/owlitzer_wings",
        PartialOverlay_LP = "Meta/Overlays/PartialOverlay_LP",
        pinecone_bomb_traps_explode = "Traps/pinecone_bomb_traps_explode",
        pinecone_bomb_traps_hold = "Traps/pinecone_bomb_traps_hold",
        pinecone_bomb_traps_ignite_LP = "Traps/pinecone_bomb_traps_ignite_LP",
        pinecone_bomb_traps_land = "Traps/pinecone_bomb_traps_land",
        pinecone_bomb_traps_pre = "Traps/pinecone_bomb_traps_pre",
        pinecone_bomb_traps_warning = "Traps/pinecone_bomb_traps_warning",
        Ping = "FX/Hits/Ping",
        place_building = "UI/Build/place_building",
        place_decor = "UI/Build/place_decor",
        place_furnishing = "UI/Build/place_furnishing",
        Player_Burn_Heart = "Props/Wellspring_energy_well/Player_Burn_Heart",
        Player_cannon_hand_shake = "Player/Movement/Player_cannon_hand_shake",
        Player_death_flop_bounce = "Player/Movement/Player_death_flop_bounce",
        Player_death_flop_bounce_bodyfall = "Player/Movement/Player_death_flop_bounce_bodyfall",
        Player_eat = "Player/Player_eat",
        Player_glass_break = "Player/Player_glass_break",
        Player_grab = "Player/Movement/Player_grab",
        Player_hop = "Player/Movement/Player_hop",
        Player_potion_drink = "Player/Player_potion_drink",
        Player_potion_refill = "Player/Player_potion_refill",
        Player_power_up = "Player/Player_power_up",
        Player_roll = "Player/Movement/Player_roll",
        player_roll_damage_cabbageroll = "FX/player_roll_damage_cabbageroll",
        Player_roll_heavy = "Player/Movement/Player_roll_heavy",
        Player_roll_light = "Player/Movement/Player_roll_light",
        Player_rummage = "Player/Movement/Player_rummage",
        Player_safe_dodge = "Player/Movement/Player_safe_dodge",
        Player_safe_recover = "Player/Movement/Player_safe_recover",
        Player_slide = "Player/Movement/Player_slide",
        Player_swish = "Player/Movement/Player_swish",
        Player_swish_light = "Player/Movement/Player_swish_light",
        Player_VO_death = "Player/Voice/Player_VO_death",
        Player_VO_hit = "Player/Voice/Player_VO_hit",
        Player_VO_yell = "Player/Voice/Player_VO_yell",
        Player_whoosh = "Player/Movement/Player_whoosh",
        Player_whoosh_heavy = "Player/Movement/Player_whoosh_heavy",
        Polearm_drill_LP = "Player/Weapon/Polearm/Polearm_drill_LP",
        Polearm_drill_single = "Player/Weapon/Polearm/Polearm_drill_single",
        Polearm_drop = "Player/Weapon/Polearm/Polearm_drop",
        Polearm_jump_atk = "Player/Weapon/Polearm/Polearm_jump_atk",
        Polearm_multithrust_LP = "Player/Weapon/Polearm/Polearm_multithrust_LP",
        Polearm_poke_1 = "Player/Weapon/Polearm/Polearm_poke_1",
        Polearm_poke_2 = "Player/Weapon/Polearm/Polearm_poke_2",
        Polearm_poke_3 = "Player/Weapon/Polearm/Polearm_poke_3",
        Polearm_poke_3_pre = "Player/Weapon/Polearm/Polearm_poke_3_pre",
        Polearm_poke_4_flurry = "Player/Weapon/Polearm/Polearm_poke_4_flurry",
        Polearm_poke_4_spin = "Player/Weapon/Polearm/Polearm_poke_4_spin",
        Polearm_poke_4_thrust = "Player/Weapon/Polearm/Polearm_poke_4_thrust",
        Polearm_Sheathe = "Player/Weapon/Polearm/Polearm_Sheathe",
        Polearm_spin_atk = "Player/Weapon/Polearm/Polearm_spin_atk",
        Polearm_Unsheathe = "Player/Weapon/Polearm/Polearm_Unsheathe",
        PopUp_LP = "Meta/Overlays/PopUp_LP",
        powerCrystal_idle_LP = "Item/powerCrystal/powerCrystal_idle_LP",
        powerCrystal_idle_shimmer = "Item/powerCrystal/powerCrystal_idle_shimmer",
        powerCrystal_rattle = "Item/powerCrystal/powerCrystal_rattle",
        powerCrystal_rumble = "Item/powerCrystal/powerCrystal_rumble",
        powerCrystal_shatter_crystal = "Item/powerCrystal/powerCrystal_shatter_crystal",
        powerCrystal_shatter_tail = "Item/powerCrystal/powerCrystal_shatter_tail",
        powerCrystal_spawn_crystallize = "Item/powerCrystal/powerCrystal_spawn_crystallize",
        powerCrystal_spawn_energy = "Item/powerCrystal/powerCrystal_spawn_energy",
        powerCrystal_spawn_impact = "Item/powerCrystal/powerCrystal_spawn_impact",
        powerCrystal_spawn_tone = "Item/powerCrystal/powerCrystal_spawn_tone",
        power_acquire = "FX/power_acquire",
        Power_AttackDice = "Player/Power/AttackDice/Power_AttackDice",
        Power_bigStick_Explode = "FX/Hits/Scatterers/Power_bigStick_Explode",
        Power_bigStick_LP = "Player/Power/BigStick/Power_bigStick_LP",
        Power_bigStick_Start = "Player/Power/BigStick/Power_bigStick_Start",
        Power_Charm_FX = "Player/Power/Charm/Power_Charm_FX",
        Power_Charm_LP = "Player/Power/Charm/Power_Charm_LP",
        Power_Charm_WeaponTrail_LP = "FX/Charm/Power_Charm_WeaponTrail_LP",
        power_drop_materialspawn_pre = "Item/power_drop_materialspawn_pre",
        power_drop_material_idle_LP = "Item/power_drop_material_idle_LP",
        power_drop_material_shatter = "Item/power_drop_material_shatter",
        power_drop_material_spawn = "Item/power_drop_material_spawn",
        Power_Electric_Arc = "Player/Power/Electric/Power_Electric_Arc",
        Power_Electric_Bolt = "Player/Power/Electric/Power_Electric_Bolt",
        Power_Electric_Bolt_Tail_Low = "Player/Power/Electric/Power_Electric_Bolt_Tail_Low",
        Power_Electric_Bolt_Zaps = "Player/Power/Electric/Power_Electric_Bolt_Zaps",
        Power_Electric_Cannon_Mortar_Launch = "FX/Whoosh/Electric/Cannon/Power_Electric_Cannon_Mortar_Launch",
        Power_Electric_Cannon_Mortar_Launch_Scatterer = "FX/Whoosh/Electric/Cannon/Power_Electric_Cannon_Mortar_Launch_Scatterer",
        Power_Electric_Cannon_Projectile_LP = "FX/Whoosh/Electric/Cannon/Power_Electric_Cannon_Projectile_LP",
        Power_Electric_Cannon_Shoot_Heavy = "FX/Whoosh/Electric/Cannon/Power_Electric_Cannon_Shoot_Heavy",
        Power_Electric_Cannon_Shoot_Light = "FX/Whoosh/Electric/Cannon/Power_Electric_Cannon_Shoot_Light",
        Power_Electric_Charged = "Player/Power/Electric/Power_Electric_Charged",
        Power_Electric_Hit = "Player/Power/Electric/Power_Electric_Hit",
        Power_Electric_Orb_LP = "Player/Power/Electric/Orb/Power_Electric_Orb_LP",
        Power_Electric_Orb_pre = "Player/Power/Electric/Orb/Power_Electric_Orb_pre",
        Power_Electric_Orb_pst = "Player/Power/Electric/Orb/Power_Electric_Orb_pst",
        Power_Electric_Orb_Pulse = "Player/Power/Electric/Orb/Power_Electric_Orb_Pulse",
        Power_Electric_Swing_Hammer_Atk1 = "FX/Whoosh/Electric/Hammer/Power_Electric_Swing_Hammer_Atk1",
        Power_Electric_Swing_Hammer_Atk2 = "FX/Whoosh/Electric/Hammer/Power_Electric_Swing_Hammer_Atk2",
        Power_Electric_Swing_Hammer_Atk3 = "FX/Whoosh/Electric/Hammer/Power_Electric_Swing_Hammer_Atk3",
        Power_Electric_Swing_Hammer_Lariat = "FX/Whoosh/Electric/Hammer/Power_Electric_Swing_Hammer_Lariat",
        Power_Electric_Swing_Hammer_Reverse = "FX/Whoosh/Electric/Hammer/Power_Electric_Swing_Hammer_Reverse",
        Power_Electric_Swing_Hammer_Smash = "FX/Whoosh/Electric/Hammer/Power_Electric_Swing_Hammer_Smash",
        Power_Electric_Swing_Hammer_Spin = "FX/Whoosh/Electric/Hammer/Power_Electric_Swing_Hammer_Spin",
        Power_Electric_Swing_Polearm_Atk1 = "FX/Whoosh/Electric/Polearm/Power_Electric_Swing_Polearm_Atk1",
        Power_Electric_Swing_Polearm_Atk2 = "FX/Whoosh/Electric/Polearm/Power_Electric_Swing_Polearm_Atk2",
        Power_Electric_Swing_Polearm_Atk3 = "FX/Whoosh/Electric/Polearm/Power_Electric_Swing_Polearm_Atk3",
        Power_Electric_Swing_Polearm_Heavy = "FX/Whoosh/Electric/Polearm/Power_Electric_Swing_Polearm_Heavy",
        Power_Electric_Swing_Polearm_Multithrust = "FX/Whoosh/Electric/Polearm/Power_Electric_Swing_Polearm_Multithrust",
        Power_Electric_Swing_Polearm_Roll = "FX/Whoosh/Electric/Polearm/Power_Electric_Swing_Polearm_Roll",
        Power_Electric_Transient = "Player/Power/Electric/Power_Electric_Transient",
        Power_Mulligan_Revive = "Player/Power/Mulligan/Power_Mulligan_Revive",
        Power_PartingGifts_Bomb_Ready = "Player/Power/PartingGifts/Power_PartingGifts_Bomb_Ready",
        Power_PewPewPew_Impact_Counter = "Player/Power/PewPewPew/Power_PewPewPew_Impact_Counter",
        Power_pew_pew_launch = "Player/Power/PewPewPew/Power_pew_pew_launch",
        Power_pump_n_dump_fx = "Player/Power/Pump n Dump/Power_pump_n_dump_fx",
        Power_pump_n_dump_LP = "Player/Power/Pump n Dump/Power_pump_n_dump_LP",
        Power_pump_n_dump_start = "Player/Power/Pump n Dump/Power_pump_n_dump_start",
        Power_Retaliation_Player = "Player/Power/Retaliation/Power_Retaliation_Player",
        Power_Retaliation_Target = "Player/Power/Retaliation/Power_Retaliation_Target",
        Power_running_shoes = "Player/Power/running_shoes/Power_running_shoes",
        Power_Shrapnel_Activate = "Player/Power/Shrapnel/Power_Shrapnel_Activate",
        Power_Shrapnel_Tail = "Player/Power/Shrapnel/Power_Shrapnel_Tail",
        Power_Teleport_Enter = "Player/Power/Teleport/Power_Teleport_Enter",
        Power_Teleport_Exit = "Player/Power/Teleport/Power_Teleport_Exit",
        Power_Teleport_Portal_LP = "Player/Power/Teleport/Power_Teleport_Portal_LP",
        Power_Teleport_Portal_Place = "Player/Power/Teleport/Power_Teleport_Portal_Place",
        Power_Teleport_Travel = "Player/Power/Teleport/Power_Teleport_Travel",
        power_upgrade = "FX/power_upgrade",
        Power_VolatileWeaponry_Explode = "Player/Power/VolatileWeaponry/VolatileWeaponry_Components/Power_VolatileWeaponry_Explode",
        Power_VolatileWeaponry_Impact_Counter = "Player/Power/VolatileWeaponry/Power_VolatileWeaponry_Impact_Counter",
        Power_VolatileWeaponry_intensity = "Player/Power/VolatileWeaponry/Power_VolatileWeaponry_intensity",
        Power_VolatileWeaponry_intensity_LP = "Player/Power/VolatileWeaponry/Power_VolatileWeaponry_intensity_LP",
        Power_VolatileWeaponry_Puff = "Player/Power/VolatileWeaponry/VolatileWeaponry_Components/Power_VolatileWeaponry_Puff",
        Power_VolatileWeaponry_Transient = "Player/Power/VolatileWeaponry/Power_VolatileWeaponry_Transient",
        purchase_armor = "Props/VendingMachine/purchase_armor",
        purchase_corestone = "Props/VendingMachine/purchase_corestone",
        purchase_dye = "Props/VendingMachine/purchase_dye",
        purchase_relicUpgrade = "Props/VendingMachine/purchase_relicUpgrade",
        Pushback_heavy = "FX/Pushback_heavy",
        recipeScreen_hide = "UI/screenHideShow/recipeScreen_hide",
        recipeScreen_show = "UI/screenHideShow/recipeScreen_show",
        refineryScreen_hide = "UI/screenHideShow/refineryScreen_hide",
        refineryScreen_show = "UI/screenHideShow/refineryScreen_show",
        remove_constructable = "UI/Build/remove_constructable",
        remove_currency_konjur = "UI/remove_currency_konjur",
        researchScreen_hide = "UI/screenHideShow/researchScreen_hide",
        researchScreen_show = "UI/screenHideShow/researchScreen_show",
        revive = "revive",
        reward_corestone = "UI/Rewards/reward_corestone",
        select_speechBubble = "UI/Speech/select_speechBubble",
        Shield_Acquire = "Player/Power/Shield/Shield_Acquire",
        Shield_Break_FX = "Player/Power/Shield/Shield_Break_FX",
        Shield_Break_UI = "Player/Power/Shield/Shield_Break_UI",
        Shield_Segment_Acquire_01 = "Player/Power/Shield/Shield_Segment_Acquire_01",
        Shield_Segment_Acquire_02 = "Player/Power/Shield/Shield_Segment_Acquire_02",
        Shield_Segment_Acquire_03 = "Player/Power/Shield/Shield_Segment_Acquire_03",
        Shield_Segment_Acquire_04 = "Player/Power/Shield/Shield_Segment_Acquire_04",
        shop_purchase = "_newForEarlyAccess/shop_purchase",
        Shotput_ammo_up = "Player/Weapon/Shotput/Shotput_ammo_up",
        Shotput_bounce = "Player/Weapon/Shotput/Shotput_bounce",
        Shotput_catch = "Player/Weapon/Shotput/Shotput_catch",
        Shotput_dash = "Player/Weapon/Shotput/Shotput_dash",
        Shotput_kick_whoosh = "Player/Weapon/Shotput/Shotput_kick_whoosh",
        Shotput_land = "Player/Weapon/Shotput/travel/Shotput_land",
        Shotput_lobbed = "Player/Weapon/Shotput/travel/Shotput_lobbed",
        Shotput_pickup = "Player/Weapon/Shotput/Shotput_pickup",
        Shotput_punch_whoosh_1 = "Player/Weapon/Shotput/Shotput_punch_whoosh_1",
        Shotput_punch_whoosh_2 = "Player/Weapon/Shotput/Shotput_punch_whoosh_2",
        Shotput_punch_whoosh_3 = "Player/Weapon/Shotput/Shotput_punch_whoosh_3",
        Shotput_rebound = "Player/Weapon/Shotput/travel/Shotput_rebound",
        Shotput_roll_pickup = "Player/Weapon/Shotput/Shotput_roll_pickup",
        Shotput_Sheathe = "Player/Weapon/Shotput/Shotput_Sheathe",
        Shotput_spiked = "Player/Weapon/Shotput/travel/Shotput_spiked",
        Shotput_thrown = "Player/Weapon/Shotput/travel/Shotput_thrown",
        Shotput_Unsheathe = "Player/Weapon/Shotput/Shotput_Unsheathe",
        Shotput_whoosh_heavy = "Player/Weapon/Shotput/Shotput_whoosh_heavy",
        Shotput_whoosh_lateFocus = "Player/Weapon/Shotput/Shotput_whoosh_lateFocus",
        Shotput_whoosh_light = "Player/Weapon/Shotput/Shotput_whoosh_light",
        Skill_BananaPeel_Eat = "Player/Skill/BananaPeel/Skill_BananaPeel_Eat",
        Skill_BananaPeel_Land = "Player/Skill/BananaPeel/Skill_BananaPeel_Land",
        Skill_BananaPeel_new_banana = "Player/Skill/BananaPeel/Skill_BananaPeel_new_banana",
        Skill_BananaPeel_Slip = "Player/Skill/BananaPeel/Skill_BananaPeel_Slip",
        Skill_BananaPeel_Toss = "Player/Skill/BananaPeel/Skill_BananaPeel_Toss",
        Skill_BuffNextAttack_CritUp = "Player/Skill/BuffNextAttack/Skill_BuffNextAttack_CritUp",
        Skill_BuffNextAttack_Pound = "Player/Skill/BuffNextAttack/Skill_BuffNextAttack_Pound",
        Skill_BuffNextAttack_Whoosh = "Player/Skill/BuffNextAttack/Skill_BuffNextAttack_Whoosh",
        Skill_CannonButt = "Player/Skill/Weapon/Skill_CannonButt",
        Skill_Cannon_ClusterShot_Burst = "_newForEarlyAccess/Weapon Skills/Cannon/Skill_Cannon_ClusterShot_Burst",
        Skill_Cannon_ClusterShot_Explode_Counter = "_newForEarlyAccess/Weapon Skills/Cannon/Skill_Cannon_ClusterShot_Explode_Counter",
        Skill_Cannon_ClusterShot_Explode_Impact = "_newForEarlyAccess/Weapon Skills/Cannon/Skill_Cannon_ClusterShot_Explode_Impact",
        Skill_Cannon_ClusterShot_Tail = "_newForEarlyAccess/Weapon Skills/Cannon/Skill_Cannon_ClusterShot_Tail",
        Skill_Cannon_ReloadAmmo = "Player/Skill/Weapon/Skill_Cannon_ReloadAmmo",
        Skill_Cannon_ReloadAmmo_full = "Player/Skill/Weapon/Skill_Cannon_ReloadAmmo_full",
        Skill_Floracrane_Charge = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Charge",
        Skill_Floracrane_Charged = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Charged",
        Skill_Floracrane_Charge_LP = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Charge_LP",
        Skill_Floracrane_Dive = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Dive",
        Skill_Floracrane_Hit = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Hit",
        Skill_Floracrane_Hold = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Hold",
        Skill_Floracrane_Impact = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Impact",
        Skill_Floracrane_Jump = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Jump",
        Skill_Floracrane_Jump_Roar = "_newForEarlyAccess/new miniboss skills/floracrane skill/Skill_Floracrane_Jump_Roar",
        Skill_Gourdo_Crouch = "_newForEarlyAccess/new miniboss skills/gourdo skill/Skill_Gourdo_Crouch",
        Skill_Gourdo_Roar = "_newForEarlyAccess/new miniboss skills/gourdo skill/Skill_Gourdo_Roar",
        Skill_Gourdo_Stand = "_newForEarlyAccess/new miniboss skills/gourdo skill/Skill_Gourdo_Stand",
        Skill_groak_vacuum = "_newForEarlyAccess/new miniboss skills/groak skill/Skill_groak_vacuum",
        Skill_groak_vacuum_hands = "_newForEarlyAccess/new miniboss skills/groak skill/Skill_groak_vacuum_hands",
        Skill_groundThrust_Charge = "Player/Skill/_shared/Skill_groundThrust_Charge",
        Skill_Hammer_Thump_Impact = "Player/Skill/Weapon/Skill_Hammer_Thump_Impact",
        Skill_Hammer_Thump_Impact_Full = "Player/Skill/Weapon/Skill_Hammer_Thump_Impact_Full",
        Skill_Hammer_Totem_Death = "Player/Skill/Weapon/Skill_Hammer_Totem_Death",
        Skill_Hammer_Totem_Slap = "Player/Skill/Weapon/Skill_Hammer_Totem_Slap",
        Skill_Hammer_Totem_Snapshot_LP = "Player/Skill/Weapon/Skill_Hammer_Totem_Snapshot_LP",
        Skill_Hammer_Totem_Spawn = "Player/Skill/Weapon/Skill_Hammer_Totem_Spawn",
        Skill_IsPlayerInTotem_Thump = "Player/Skill/Weapon/Music Layers/Skill_IsPlayerInTotem_Thump",
        Skill_IsPlayerInTotem_Thump_Command = "Player/Skill/Weapon/Music Layers/Skill_IsPlayerInTotem_Thump_Command",
        Skill_Megatreek_Cast_Impact = "Player/Skill/Megatreek/Root Line/Skill_Megatreek_Cast_Impact",
        Skill_Megatreek_Cast_Roar = "Player/Skill/Megatreek/Root Line/Skill_Megatreek_Cast_Roar",
        Skill_Megatreek_Defend_Spawn = "Player/Skill/Megatreek/Defensive Tentacle/Skill_Megatreek_Defend_Spawn",
        Skill_Megatreek_Defend_Warn = "Player/Skill/Megatreek/Defensive Tentacle/Skill_Megatreek_Defend_Warn",
        Skill_Megatreek_Defend_Whoosh = "Player/Skill/Megatreek/Defensive Tentacle/Skill_Megatreek_Defend_Whoosh",
        Skill_Megatreek_Queue = "Player/Skill/Megatreek/Root Line/Skill_Megatreek_Queue",
        Skill_Megatreek_Spike = "Player/Skill/Megatreek/Root Line/Skill_Megatreek_Spike",
        Skill_Megatreek_Warn = "Player/Skill/Megatreek/Root Line/Skill_Megatreek_Warn",
        Skill_Megatreek_Whoosh = "Player/Skill/Megatreek/Root Line/Skill_Megatreek_Whoosh",
        Skill_Parry = "Player/Skill/Skill_Parry",
        Skill_Polearm_Shove = "Player/Skill/Weapon/Skill_Polearm_Shove",
        Skill_Polearm_Vault_Jump = "Player/Skill/Weapon/Skill_Polearm_Vault_Jump",
        Skill_Polearm_Vault_Land = "Player/Skill/Weapon/Skill_Polearm_Vault_Land",
        Skill_Polearm_Vault_Plant = "Player/Skill/Weapon/Skill_Polearm_Vault_Plant",
        Skill_Shotput_Land_Explode = "_newForEarlyAccess/Weapon Skills/Shotput/Boomball/Skill_Shotput_Land_Explode",
        Skill_Shotput_Recall = "Player/Skill/Weapon/Skill_Shotput_Recall",
        Skill_Shotput_Slam_Bounce = "_newForEarlyAccess/Weapon Skills/Shotput/Skill_Shotput_Slam_Bounce",
        Skill_Shotput_Slam_Jump = "_newForEarlyAccess/Weapon Skills/Shotput/Skill_Shotput_Slam_Jump",
        Skill_Shotput_Slam_Throw = "_newForEarlyAccess/Weapon Skills/Shotput/Skill_Shotput_Slam_Throw",
        Skill_ThrowStone_Charge_LP = "Player/Skill/ThrowStone/Skill_ThrowStone_Charge_LP",
        Skill_ThrowStone_Grab = "Player/Skill/ThrowStone/Skill_ThrowStone_Grab",
        Skill_ThrowStone_Toss = "Player/Skill/ThrowStone/Skill_ThrowStone_Toss",
        Skill_ThrowStone_Travel = "Player/Skill/ThrowStone/Skill_ThrowStone_Travel",
        Skill_unstableEquilibrium_fx = "Player/Skill/Weapon/Unstable Equilibrium/Skill_unstableEquilibrium_fx",
        Skill_unstableEquilibrium_LP = "Player/Skill/Weapon/Unstable Equilibrium/Skill_unstableEquilibrium_LP",
        Skill_unstableEquilibrium_start = "Player/Skill/Weapon/Unstable Equilibrium/Skill_unstableEquilibrium_start",
        Skill_Yammo_Punch_Hit = "_newForEarlyAccess/new miniboss skills/yammoskill/Skill_Yammo_Punch_Hit",
        Skill_Yammo_Punch_Roar = "_newForEarlyAccess/new miniboss skills/yammoskill/Skill_Yammo_Punch_Roar",
        Skill_Yammo_Punch_Whoosh = "_newForEarlyAccess/new miniboss skills/yammoskill/Skill_Yammo_Punch_Whoosh",
        Skill_Yammo_WindUp_LP = "_newForEarlyAccess/new miniboss skills/yammoskill/Skill_Yammo_WindUp_LP",
        Skill_Yammo_WindUp_Whoosh = "_newForEarlyAccess/new miniboss skills/yammoskill/Skill_Yammo_WindUp_Whoosh",
        slideshow_text = "UI/slideshow_text",
        slowpoke_10 = "Creature/slowpoke/unused/slowpoke_10",
        slowpoke_11 = "Creature/slowpoke/unused/slowpoke_11",
        slowpoke_acid_splash = "Creature/slowpoke/slowpoke_acid_splash",
        slowpoke_body_slam_counted = "Creature/slowpoke/slowpoke_body_slam_counted",
        slowpoke_body_slam_land = "Creature/slowpoke/slowpoke_body_slam_land",
        slowpoke_breath = "Creature/slowpoke/slowpoke_breath",
        slowpoke_death = "Creature/slowpoke/slowpoke_death",
        slowpoke_footstep = "Creature/slowpoke/slowpoke_footstep",
        slowpoke_grimmace = "Creature/slowpoke/slowpoke_grimmace",
        slowpoke_hit = "Creature/slowpoke/slowpoke_hit",
        slowpoke_knockdown = "Creature/slowpoke/slowpoke_knockdown",
        slowpoke_shoot_LP = "Creature/slowpoke/slowpoke_shoot_LP",
        slowpoke_spit_bomb = "Creature/slowpoke/slowpoke_spit_bomb",
        slowpoke_spit_bomb_hold = "Creature/slowpoke/slowpoke_spit_bomb_hold",
        slowpoke_spit_bomb_warning = "Creature/slowpoke/slowpoke_spit_bomb_warning",
        slowpoke_whoosh = "Creature/slowpoke/slowpoke_whoosh",
        Snapshot_BossIntro_LP = "Meta/Snapshot_BossIntro_LP",
        Snapshot_Interacting_LP = "Meta/Snapshot_Interacting_LP",
        Snapshot_MainQuest_Intro = "Meta/Snapshot_MainQuest_Intro",
        Snapshot_Wanderer_LP = "Meta/Snapshot_Wanderer_LP",
        spawn_plant_forest_large = "Spawn/spawn_plant_forest_large",
        spawn_plant_forest_large_LP = "Spawn/spawn_plant_forest_large_LP",
        spawn_plant_forest_LP = "Spawn/spawn_plant_forest_LP",
        spawn_plant_forest_spawn = "Spawn/spawn_plant_forest_spawn",
        spawn_plant_swamp_large = "Spawn/spawn_plant_swamp_large",
        spawn_plant_swamp_large_LP = "Spawn/spawn_plant_swamp_large_LP",
        spawn_plant_swamp_LP = "Spawn/spawn_plant_swamp_LP",
        spawn_plant_swamp_spawn = "Spawn/spawn_plant_swamp_spawn",
        spawn_whoosh_large = "Spawn/spawn_whoosh_large",
        spawn_whoosh_medium = "Spawn/spawn_whoosh_medium",
        spawn_whoosh_small = "Spawn/spawn_whoosh_small",
        speechBubble_appear = "UI/Speech/speechBubble_appear",
        speechBubble_close = "UI/Speech/speechBubble_close",
        speechBubble_skip = "UI/Speech/speechBubble_skip",
        sporemon__10 = "Creature/sporemon/sporemon_ 10",
        sporemon__11 = "Creature/sporemon/sporemon_ 11",
        sporemon__12 = "Creature/sporemon/sporemon_ 12",
        sporemon__13 = "Creature/sporemon/sporemon_ 13",
        sporemon_bite = "Creature/sporemon/sporemon_bite",
        sporemon_bite_pre = "Creature/sporemon/sporemon_bite_pre",
        sporemon_death = "Creature/sporemon/sporemon_death",
        sporemon_projectile_warning = "Creature/sporemon/sporemon_projectile_warning",
        sporemon_shoot = "Creature/sporemon/sporemon_shoot",
        sporemon_shoot_pre = "Creature/sporemon/sporemon_shoot_pre",
        sporemon_spike = "Creature/sporemon/sporemon_spike",
        sporemon_spike_pre = "Creature/sporemon/sporemon_spike_pre",
        sporemon_squish = "Creature/sporemon/sporemon_squish",
        sporemon_vo = "Creature/sporemon/sporemon_vo",
        sporemon_whip = "Creature/sporemon/sporemon_whip",
        spore_cloud_confused = "Props/spore_cloud/spore_cloud_confused",
        spore_cloud_damage = "Props/spore_cloud/spore_cloud_damage",
        spore_cloud_explosion = "Props/spore_cloud/spore_cloud_explosion",
        spore_cloud_heal = "Props/spore_cloud/spore_cloud_heal",
        spore_cloud_juggernaut = "Props/spore_cloud/spore_cloud_juggernaut",
        spore_cloud_layer_1 = "spore_cloud_layer_1",
        spore_cloud_shield = "Props/spore_cloud/spore_cloud_shield",
        spore_cloud_shrink = "Props/spore_cloud/spore_cloud_shrink",
        status_confused_enemy = "FX/Status/status_confused_enemy",
        status_confused_friendly = "FX/Status/status_confused_friendly",
        status_confused_LP = "FX/Status/status_confused_LP",
        status_juggernaut_apply = "FX/Status/status_juggernaut_apply",
        status_juggernaut_enemy = "FX/Status/status_juggernaut_enemy",
        status_juggernaut_friendly = "FX/Status/status_juggernaut_friendly",
        status_smallify_enemy = "FX/Status/status_smallify_enemy",
        status_smallify_friendly = "FX/Status/status_smallify_friendly",
        sting_miniboss_intro = "UI/Stingers/sting_miniboss_intro",
        swampPath_open = "Level/Swamp/swampPath_open",
        swampPath_open_magic = "Level/Swamp/swampPath_open_magic",
        swampPath_open_moan = "Level/Swamp/swampPath_open_moan",
        swarmy_be2 = "Creature/swarmy/swarmy_be2",
        swarmy_bodfall = "Creature/swarmy/swarmy_bodfall",
        swarmy_dash = "Creature/swarmy/swarmy_dash",
        swarmy_death = "Creature/swarmy/swarmy_death",
        swarmy_footstep = "Creature/swarmy/swarmy_footstep",
        swarmy_knockdown_hold = "Creature/swarmy/swarmy_knockdown_hold",
        swarmy_splat = "Creature/swarmy/swarmy_splat",
        swarmy_template_10 = "Creature/swarmy/swarmy_template 10",
        swarmy_template_11 = "Creature/swarmy/swarmy_template 11",
        swarmy_template_12 = "Creature/swarmy/swarmy_template 12",
        swarmy_template_13 = "Creature/swarmy/swarmy_template 13",
        swarmy_template_14 = "Creature/swarmy/swarmy_template 14",
        swarmy_uppercut = "Creature/swarmy/swarmy_uppercut",
        swarmy_vo_hit = "Creature/swarmy/swarmy_vo_hit",
        swarmy_vo_long = "Creature/swarmy/swarmy_vo_long",
        swarmy_vo_short1 = "Creature/swarmy/swarmy_vo_short1",
        swarmy_vo_short3 = "Creature/swarmy/swarmy_vo_short3",
        test_speech_comma = "NPC/test_speech_comma",
        test_speech_endOfSentence = "NPC/test_speech_endOfSentence",
        test_speech_exclamation = "NPC/test_speech_exclamation",
        test_speech_happy = "NPC/test_speech_happy",
        test_speech_neutral = "NPC/test_speech_neutral",
        test_speech_period = "NPC/test_speech_period",
        test_speech_question = "NPC/test_speech_question",
        thatcher_12 = "Creature/thatcher/thatcher 12",
        thatcher_13 = "Creature/thatcher/thatcher 13",
        thatcher_14 = "Creature/thatcher/thatcher 14",
        thatcher_15 = "Creature/thatcher/thatcher 15",
        thatcher_acid_splash = "Creature/thatcher/thatcher_acid_splash",
        thatcher_behaviour_1 = "Creature/thatcher/thatcher_behaviour_1",
        thatcher_bodyfall = "Creature/thatcher/thatcher_bodyfall",
        thatcher_catch = "Creature/thatcher/thatcher_catch",
        thatcher_chatter = "Creature/thatcher/thatcher_chatter",
        thatcher_dash = "Creature/thatcher/thatcher_dash",
        thatcher_death = "Creature/thatcher/thatcher_death",
        thatcher_foley = "Creature/thatcher/thatcher_foley",
        thatcher_footstep = "Creature/thatcher/thatcher_footstep",
        thatcher_footstep_stop = "Creature/thatcher/thatcher_footstep_stop",
        thatcher_geyser_explode = "Creature/thatcher/thatcher_geyser_explode",
        thatcher_geyser_LP = "Creature/thatcher/thatcher_geyser_LP",
        thatcher_ground_hit = "Creature/thatcher/thatcher_ground_hit",
        thatcher_grunt = "Creature/thatcher/thatcher_grunt",
        thatcher_hit = "Creature/thatcher/thatcher_hit",
        thatcher_hold = "Creature/thatcher/thatcher_hold",
        thatcher_knockdown_temp = "Creature/thatcher/thatcher_knockdown_temp",
        thatcher_puke = "Creature/thatcher/thatcher_puke",
        thatcher_puke_hold = "Creature/thatcher/thatcher_puke_hold",
        thatcher_slide = "Creature/thatcher/thatcher_slide",
        thatcher_spit = "Creature/thatcher/thatcher_spit",
        thatcher_swing_hold = "Creature/thatcher/thatcher_swing_hold",
        thatcher_swipe = "Creature/thatcher/thatcher_swipe",
        thatcher_swipe_2 = "Creature/thatcher/thatcher_swipe_2",
        thatcher_taunt_1 = "Creature/thatcher/thatcher_taunt_1",
        thatcher_twirl_LP = "Creature/thatcher/thatcher_twirl_LP",
        thatcher_vo_1 = "Creature/thatcher/thatcher_vo_1",
        thatcher_vo_2 = "Creature/thatcher/thatcher_vo_2",
        thatcher_whip = "Creature/thatcher/thatcher_whip",
        thatcher_whoosh = "Creature/thatcher/thatcher_whoosh",
        thatcher_whoosh2 = "Creature/thatcher/thatcher_whoosh2",
        thatcher_wings = "Creature/thatcher/thatcher_wings",
        thatcher_yell = "Creature/thatcher/thatcher_yell",
        toots_speech_neutral = "NPC/toots_speech_neutral",
        totolili_bodyfall = "Creature/totolili/totolili_bodyfall",
        totolili_death = "Creature/totolili/totolili_death",
        totolili_foley = "Creature/totolili/totolili_foley",
        totolili_footstep = "Creature/totolili/totolili_footstep",
        totolili_hit = "Creature/totolili/totolili_hit",
        totolili_rip = "Creature/totolili/totolili_rip",
        totolili_spin = "Creature/totolili/totolili_spin",
        totolili_spin_LP = "Creature/totolili/totolili_spin_LP",
        totolili_tell = "Creature/totolili/totolili_tell",
        totolili_toss_spin = "Creature/totolili/totolili_toss_spin",
        totolili_toss_spin_pst = "Creature/totolili/totolili_toss_spin_pst",
        totolili_vo1 = "Creature/totolili/totolili_vo1",
        totolili_whoosh = "Creature/totolili/totolili_whoosh",
        town_crystal_activate = "Props/town_crystal_activate",
        town_crystal_beam_LP = "Props/town_crystal_beam_LP",
        town_crystal_close = "Props/town_crystal_close",
        town_crystal_idle_LP = "Props/town_crystal_idle_LP",
        town_crystal_open = "Props/town_crystal_open",
        Trap_Warning_Beep = "Traps/Trap_Warning_Beep",
        Trap_Warning_Beep2 = "Traps/Trap_Warning_Beep2",
        Trap_Weed_Spikes_disarm = "Traps/Trap_Weed_Spikes_disarm",
        Trap_Weed_Spikes_hold = "Traps/Trap_Weed_Spikes_hold",
        Trap_Weed_Spikes_pre = "Traps/Trap_Weed_Spikes_pre",
        Trap_Weed_Spikes_shoot = "Traps/Trap_Weed_Spikes_shoot",
        Trap_wind_totem_ball = "Traps/Trap_wind_totem_ball",
        travelScreen_destination_atBoss = "UI/travelScreen/travelScreen_destination_atBoss",
        travelScreen_destination_highlight = "UI/travelScreen/travelScreen_destination_highlight",
        travelScreen_path_LP = "UI/travelScreen/travelScreen_path_LP",
        travelScreen_tallyMark_across = "UI/travelScreen/travelScreen_tallyMark_across",
        travelScreen_tallyMark_down = "UI/travelScreen/travelScreen_tallyMark_down",
        travelScreen_tallyMark_misc = "UI/travelScreen/travelScreen_tallyMark_misc",
        travelScreen_tallyMark_pressDown = "UI/travelScreen/travelScreen_tallyMark_pressDown",
        travelScreen_unroll = "UI/travelScreen/travelScreen_unroll",
        travelScreen_walk = "UI/travelScreen/travelScreen_walk",
        travelScreen_walk_stop = "UI/travelScreen/travelScreen_walk_stop",
        treemon_blink = "Creature/treemon/treemon_blink",
        treemon_hit = "Creature/treemon/treemon_hit",
        treemon_projectile_air_LP = "Creature/treemon/treemon_projectile_air_LP",
        treemon_projectile_break = "Creature/treemon/treemon_projectile_break",
        treemon_projectile_pre = "Creature/treemon/treemon_projectile_pre",
        treemon_projectile_warning = "Creature/treemon/treemon_projectile_warning",
        treemon_release = "Creature/treemon/treemon_release",
        treemon_root_extrude = "Creature/treemon/treemon_root_extrude",
        treemon_root_extrude_pre = "Creature/treemon/treemon_root_extrude_pre",
        treemon_root_LP = "Creature/treemon/treemon_root_LP",
        treemon_root_warning = "Creature/treemon/treemon_root_warning",
        treemon_shake = "Creature/treemon/treemon_shake",
        ui_action_blocked = "UI/_defaults/ui_action_blocked",
        ui_arrow_left = "UI/_defaults/ui_arrow_left",
        ui_arrow_right = "UI/_defaults/ui_arrow_right",
        ui_chat_messageReceived = "UI/chat/ui_chat_messageReceived",
        ui_chat_messageSent = "UI/chat/ui_chat_messageSent",
        ui_confirm_keybind = "UI/ui_confirm_keybind",
        ui_dropdown_click = "UI/_defaults/ui_dropdown_click",
        ui_dropdown_collapse = "UI/_defaults/ui_dropdown_collapse",
        ui_dropdown_expand = "UI/_defaults/ui_dropdown_expand",
        ui_dungeonProgressWidget_LP = "UI/dungeonProgressWidget/ui_dungeonProgressWidget_LP",
        ui_dungeonProgressWidget_start = "UI/dungeonProgressWidget/ui_dungeonProgressWidget_start",
        ui_endOfRun_unlock_power = "UI/ui_endOfRun_unlock_power",
        ui_fullscreen_enter = "UI/_transitions/ui_fullscreen_enter",
        ui_fullscreen_exit = "UI/_transitions/ui_fullscreen_exit",
        ui_input_up_confirm_save = "UI/ui_input_up_confirm_save",
        ui_input_up_play = "UI/ui_input_up_play",
        ui_keypress = "UI/ui_keypress",
        ui_marketplacePurchase = "UI/ui_marketplacePurchase",
        ui_mastery_claim = "UI/Mastery/ui_mastery_claim",
        ui_mastery_monster_complete = "UI/Mastery/ui_mastery_monster_complete",
        ui_mastery_progress = "UI/Mastery/ui_mastery_progress",
        ui_mastery_unlock_reveal = "UI/Mastery/ui_mastery_unlock_reveal",
        ui_mastery_weapon_complete = "UI/Mastery/ui_mastery_weapon_complete",
        ui_mpCountdownTick = "UI/multiplayer/ui_mpCountdownTick",
        ui_networking_coop_show = "UI/titleScreen/ui_networking_coop_show",
        ui_offscreenIndicator_hide = "UI/ui_offscreenIndicator_hide",
        ui_offscreenIndicator_show = "UI/ui_offscreenIndicator_show",
        ui_overlay_enter = "UI/_transitions/ui_overlay_enter",
        ui_overlay_exit = "UI/_transitions/ui_overlay_exit",
        ui_pauseScreen_enter = "UI/pauseScreen/ui_pauseScreen_enter",
        ui_pauseScreen_exit = "UI/pauseScreen/ui_pauseScreen_exit",
        ui_playerFollowStatusWidget_close = "UI/Power Ring/ui_playerFollowStatusWidget_close",
        ui_playerFollowStatusWidget_hover = "UI/Power Ring/ui_playerFollowStatusWidget_hover",
        ui_playerFollowStatusWidget_open_equipment = "UI/Power Ring/ui_playerFollowStatusWidget_open_equipment",
        ui_playerFollowStatusWidget_open_powers = "UI/Power Ring/ui_playerFollowStatusWidget_open_powers",
        ui_playerFollowStatusWidget_page = "UI/Power Ring/ui_playerFollowStatusWidget_page",
        ui_playerFollowStatusWidget_show = "UI/Power Ring/ui_playerFollowStatusWidget_show",
        ui_playerFollowStatusWidget_tooltip_show = "UI/Power Ring/ui_playerFollowStatusWidget_tooltip_show",
        ui_popup_enter = "UI/_transitions/ui_popup_enter",
        ui_popup_exit = "UI/_transitions/ui_popup_exit",
        ui_purchaseColor = "UI/characterCustomization/ui_purchaseColor",
        ui_randomize = "UI/characterCustomization/ui_randomize",
        ui_revert_undo = "UI/characterCustomization/ui_revert_undo",
        ui_roomBonusScreen_panel_show = "UI/roomBonusScreen/ui_roomBonusScreen_panel_show",
        ui_roomBonusScreen_playerNumberTone = "UI/roomBonusScreen/ui_roomBonusScreen_playerNumberTone",
        ui_roomBonusScreen_playerTurnNotification = "UI/roomBonusScreen/ui_roomBonusScreen_playerTurnNotification",
        ui_simulate_click = "UI/_defaults/ui_simulate_click",
        ui_sting_mysteryEncounter = "UI/Stingers/ui_sting_mysteryEncounter",
        ui_temp_sound = "UI/ui_temp_sound",
        ui_toggle_off = "UI/_defaults/ui_toggle_off",
        ui_toggle_on = "UI/_defaults/ui_toggle_on",
        ui_waitingForPlayersScreen_show = "UI/multiplayer/ui_waitingForPlayersScreen_show",
        ui_wanderer_grantRelic = "UI/ui_wanderer_grantRelic",
        ui_weightMeter_adjust_down = "UI/weightmeter/ui_weightMeter_adjust_down",
        ui_weightMeter_adjust_up = "UI/weightmeter/ui_weightMeter_adjust_up",
        unlock_new_armour = "UI/Forge/unlock_new_armour",
        upgrade_armour = "UI/Forge/upgrade_armour",
        vendingMachine_burst = "Props/VendingMachine/vendingMachine_burst",
        vendingMachine_crack_lg = "Props/VendingMachine/vendingMachine_crack_lg",
        vendingMachine_crack_med = "Props/VendingMachine/vendingMachine_crack_med",
        vendingMachine_crack_sm = "Props/VendingMachine/vendingMachine_crack_sm",
        vendingMachine_deposit_LP = "Props/VendingMachine/vendingMachine_deposit_LP",
        vendingMachine_deposit_oneShot = "Props/VendingMachine/vendingMachine_deposit_oneShot",
        vendingMachine_fill_LP = "Props/VendingMachine/vendingMachine_fill_LP",
        vendingMachine_glub = "Props/VendingMachine/vendingMachine_glub",
        vendingMachine_idle_LP = "Props/VendingMachine/vendingMachine_idle_LP",
        vendingMachine_outOfTeffra = "Props/VendingMachine/vendingMachine_outOfTeffra",
        Wellspring_Activate = "Props/Wellspring_energy_well/Wellspring_Activate",
        Wellspring_Bounce = "Props/Wellspring_energy_well/Wellspring_Bounce",
        Wellspring_Gear_Tick_Backward = "Props/Wellspring_energy_well/Wellspring_Gear_Tick_Backward",
        Wellspring_Gear_Tick_Backward_Slow = "Props/Wellspring_energy_well/Wellspring_Gear_Tick_Backward_Slow",
        Wellspring_Gear_Tick_Forward = "Props/Wellspring_energy_well/Wellspring_Gear_Tick_Forward",
        Wellspring_Gear_Tick_Forward_Fast = "Props/Wellspring_energy_well/Wellspring_Gear_Tick_Forward_Fast",
        Wellspring_Gear_Tick_Forward_Slow = "Props/Wellspring_energy_well/Wellspring_Gear_Tick_Forward_Slow",
        Wellspring_LP = "Props/Wellspring_energy_well/Wellspring_LP",
        Wellspring_Open = "Props/Wellspring_energy_well/Wellspring_Open",
        Wellspring_Pillar_Activate = "Props/Wellspring Pillar_energy_well/Wellspring_Pillar_Activate",
        Wellspring_Pillar_LevelUp = "Props/Wellspring Pillar_energy_well/Wellspring_Pillar_LevelUp",
        Wellspring_Pillar_Switch = "Props/Wellspring Pillar_energy_well/Wellspring_Pillar_Switch",
        Wellspring_Pulse_Hard = "Props/Wellspring_energy_well/Wellspring_Pulse_Hard",
        Wellspring_Rattle = "Props/Wellspring_energy_well/Wellspring_Rattle",
        Wellspring_Shake_Small = "Props/Wellspring_energy_well/Wellspring_Shake_Small",
        Wellspring_Shift_Down = "Props/Wellspring_energy_well/Wellspring_Shift_Down",
        Wellspring_Shift_Up = "Props/Wellspring_energy_well/Wellspring_Shift_Up",
        Wellspring_Sparks = "Props/Wellspring_energy_well/Wellspring_Sparks",
        windmon_death = "Creature/windmon/windmon_death",
        windmon_shoot = "Creature/windmon/windmon_shoot",
        windmon_spin = "Creature/windmon/windmon_spin",
        windmon_template_10 = "Creature/windmon/windmon_template 10",
        windmon_template_11 = "Creature/windmon/windmon_template 11",
        windmon_template_12 = "Creature/windmon/windmon_template 12",
        windmon_template_13 = "Creature/windmon/windmon_template 13",
        windmon_template_5 = "Creature/windmon/windmon_template 5",
        windmon_template_6 = "Creature/windmon/windmon_template 6",
        windmon_template_7 = "Creature/windmon/windmon_template 7",
        windmon_template_8 = "Creature/windmon/windmon_template 8",
        windmon_template_9 = "Creature/windmon/windmon_template 9",
        windmon_wind = "Creature/windmon/windmon_wind",
        windmon_wind_LP = "Creature/windmon/windmon_wind_LP",
        windmon_wind_pre = "Creature/windmon/windmon_wind_pre",
        woworm_bodyfall = "Creature/woworm/woworm_bodyfall",
        woworm_breath_in = "Creature/woworm/woworm_breath_in",
        woworm_breath_out = "Creature/woworm/woworm_breath_out",
        woworm_death = "Creature/woworm/woworm_death",
        woworm_foley = "Creature/woworm/woworm_foley",
        woworm_footstep = "Creature/woworm/woworm_footstep",
        woworm_hit = "Creature/woworm/woworm_hit",
        woworm_knockdown = "Creature/woworm/woworm_knockdown",
        woworm_puke = "Creature/woworm/woworm_puke",
        woworm_puke_LP = "Creature/woworm/woworm_puke_LP",
        woworm_puke_pre = "Creature/woworm/woworm_puke_pre",
        woworm_shell_foley = "Creature/woworm/woworm_shell_foley",
        woworm_shell_hit = "Creature/woworm/woworm_shell_hit",
        woworm_slam = "Creature/woworm/woworm_slam",
        woworm_slam_pre = "Creature/woworm/woworm_slam_pre",
        woworm_splash = "Creature/woworm/woworm_splash",
        woworm_tell = "Creature/woworm/woworm_tell",
        woworm_tell_5 = "Creature/woworm/woworm_tell 5",
        woworm_whoosh = "Creature/woworm/woworm_whoosh",
        yammo_behavior_1 = "Creature/yammo/yammo_behavior_1",
        yammo_behavior_2 = "Creature/yammo/yammo_behavior_2",
        yammo_breath = "Creature/yammo/yammo_breath",
        yammo_death = "Creature/yammo/yammo_death",
        yammo_elite_death = "Creature/yammo/yammo_elite_death",
        yammo_elite_run = "Creature/yammo/yammo_elite_run",
        yammo_footstep = "Creature/yammo/yammo_footstep",
        yammo_get_up = "Creature/yammo/yammo_get_up",
        yammo_heavy_slam = "Creature/yammo/yammo_heavy_slam",
        yammo_heavy_slam_lift = "Creature/yammo/yammo_heavy_slam_lift",
        yammo_hit = "Creature/yammo/yammo_hit",
        yammo_hit_vo = "Creature/yammo/yammo_hit_vo",
        yammo_idle = "Creature/yammo/yammo_idle",
        yammo_knockdown = "Creature/yammo/yammo_knockdown",
        yammo_knockdown_idle = "Creature/yammo/yammo_knockdown_idle",
        yammo_pre_knockdown = "Creature/yammo/yammo_pre_knockdown",
        yammo_run = "Creature/yammo/yammo_run",
        yammo_slam_pre = "Creature/yammo/yammo_slam_pre",
        yammo_stomp = "Creature/yammo/yammo_stomp",
        yammo_swing = "Creature/yammo/yammo_swing",
        yammo_swing_counted = "Creature/yammo/yammo_swing_counted",
        yammo_vo = "Creature/yammo/yammo_vo",
        yammo_whoosh_heavy = "Creature/yammo/yammo_whoosh_heavy",
        zucco_bahavior_1 = "Creature/zucco/voice/zucco_bahavior_1",
        zucco_bahavior_2 = "Creature/zucco/voice/zucco_bahavior_2",
        zucco_bodyfall = "Creature/zucco/zucco_bodyfall",
        zucco_breath_in = "Creature/zucco/voice/zucco_breath_in",
        zucco_breath_out = "Creature/zucco/voice/zucco_breath_out",
        zucco_claw_unstuck = "Creature/zucco/zucco_claw_unstuck",
        zucco_death = "Creature/zucco/voice/zucco_death",
        zucco_dig = "Creature/zucco/zucco_dig",
        zucco_flinch = "Creature/zucco/voice/zucco_flinch",
        zucco_foley1 = "Creature/zucco/zucco_foley1",
        zucco_foley2 = "Creature/zucco/zucco_foley2",
        zucco_footstep = "Creature/zucco/zucco_footstep",
        zucco_grunts_1 = "Creature/zucco/voice/zucco_grunts_1",
        zucco_grunts_2 = "Creature/zucco/voice/zucco_grunts_2",
        zucco_grunts_3 = "Creature/zucco/voice/zucco_grunts_3",
        zucco_hit = "Creature/zucco/voice/zucco_hit",
        zucco_idle = "Creature/zucco/voice/zucco_idle",
        zucco_knockdown = "Creature/zucco/voice/zucco_knockdown",
        zucco_slice_sfx1 = "Creature/zucco/zucco_slice_sfx1",
        zucco_slice_sfx2 = "Creature/zucco/zucco_slice_sfx2",
        zucco_slice_sfx3 = "Creature/zucco/zucco_slice_sfx3",
        zucco_swipe4_end = "Creature/zucco/zucco_swipe4_end",
        zucco_swipe4_LP = "Creature/zucco/zucco_swipe4_LP",
        zucco_swipe4_start = "Creature/zucco/zucco_swipe4_start",
        zucco_swipe_1 = "Creature/zucco/voice/zucco_swipe_1",
        zucco_swipe_2 = "Creature/zucco/voice/zucco_swipe_2",
        zucco_swipe_3 = "Creature/zucco/voice/zucco_swipe_3",
        zucco_trap = "Creature/zucco/voice/zucco_trap",
        zucco_trap_explode = "Creature/zucco/zucco_trap_explode",
        zucco_trap_pre = "Creature/zucco/zucco_trap_pre",
        zucco_trap_sfx = "Creature/zucco/zucco_trap_sfx",
        zucco_whoosh = "Creature/zucco/zucco_whoosh",
        zucco_windmill_hold = "Creature/zucco/voice/zucco_windmill_hold",
        zucco_windmill_LP = "Creature/zucco/zucco_windmill_LP",
    },


    Bus =
    {
        ____PlayerCritical = "Stereo Output/SFX/####PlayerCritical",
        ___PlayerGenerated = "Stereo Output/SFX/###PlayerGenerated",
        __PlayerInteresting = "Stereo Output/SFX/##PlayerInteresting",
        _Environment = "Stereo Output/SFX/#Environment",
        _PlayerAssociated = "Stereo Output/SFX/#PlayerAssociated",
        Ambience = "Stereo Output/Ambience",
        Ambience_Bed = "Stereo Output/Ambience/Ambience Bed",
        Ambience_Birds = "Stereo Output/Ambience/Ambience Birds",
        Ambient_Buildings = "Stereo Output/Ambience/Ambient Buildings",
        bandicoot = "Stereo Output/SFX/#Environment/SFX_Boss/bandicoot",
        battoad = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Tough Standard/battoad",
        beats = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/beats",
        BeatSynced = "Stereo Output/SFX/#PlayerAssociated/BeatSynced",
        blarmadillo = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/blarmadillo",
        blarmadillo_elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Standard Elite/blarmadillo_elite",
        Boss_LP = "Stereo Output/Music/Music_Boss/Boss LP",
        Boss_Stinger = "Stereo Output/Music/Music_Boss/Boss Stinger",
        bulbug = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/bulbug",
        bunippy = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/bunippy",
        cabbageroll = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/cabbageroll",
        cabbageroll_SFX = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/cabbageroll/cabbageroll SFX",
        cabbageroll_VO = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/cabbageroll/cabbageroll VO",
        cabbageroll_elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Standard Elite/cabbageroll_elite",
        Cannon = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Cannon",
        Cannon_Mortar_Explosion = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Cannon/Cannon Mortar Explosion",
        Cannon_Mortar_Launch = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Cannon/Cannon Mortar Launch",
        Cannon_Reload = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Cannon/Cannon Reload",
        Cannon_Shockwave = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Ducked On Hits/Cannon Shockwave",
        Cannon_Shoot = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Cannon/Cannon Shoot",
        Charm = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Charm",
        Cleaver = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Cleaver",
        coinFlip = "Stereo Output/SFX/NonCombat/coinFlip",
        Creature_Explode = "Stereo Output/SFX/##PlayerInteresting/Creature Explode",
        Creature_Sounds___Long = "Stereo Output/SFX/#Environment/Creatures/Creature Sounds - Long",
        Creatures = "Stereo Output/SFX/#Environment/Creatures",
        Creatures_Combat = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat",
        Creatures_Elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite",
        Creatures_Emote = "Stereo Output/SFX/#Environment/Creatures/Creatures Emote",
        Creatures_Standard = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard",
        Creatures_Standard_Elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Standard Elite",
        Creatures_Tough_Elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Tough Elite",
        Creatures_Tough_Standard = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Tough Standard",
        Creatures_Weak_Standard = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard",
        Crits = "Stereo Output/SFX/###PlayerGenerated/Hits/Crits",
        Death_Ring = "Stereo Output/SFX/####PlayerCritical/Hits Player/Death Ring",
        Delay = "Stereo Output/SFX/Delay",
        dirt_footstep = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Foley/dirt_footstep",
        Dungeons = "Stereo Output/Music/Levels/Dungeons",
        Electric = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric",
        Electric_Arc = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric FX/Electric Arc",
        Electric_Bolt = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric FX/Electric Bolt",
        Electric_Charge = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric Charge",
        Electric_FX = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric FX",
        Electric_Tails = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric Tails",
        Electric_Weapon = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric Weapon",
        Electric_Weapon_Regular = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric Weapon/Electric Weapon Regular",
        Electric_Weapon_Special = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Electric/Electric Weapon/Electric Weapon Special",
        Elite_Creatures = "Stereo Output/SFX/#Environment/Creatures/Elite Creatures",
        Emote = "Stereo Output/SFX/Emote",
        emotes = "Stereo Output/SFX/##PlayerInteresting/emotes",
        Emote_Mvmt = "Stereo Output/SFX/Emote/Emote_Mvmt",
        Emote_SFX = "Stereo Output/SFX/Emote/Emote_SFX",
        Emote_Speech = "Stereo Output/SFX/NonCombat/Speech/Speech_Player/Emote_Speech",
        Encounters = "Stereo Output/Music/Levels/Encounters",
        EndOfRun_Meters = "Stereo Output/UI/UI EndOfRun/EndOfRun_Meters",
        eyev = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Tough Standard/eyev",
        floracrane = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Tough Elite/floracrane",
        FlyingMachine_and_Slideshow = "Stereo Output/SFX/NonCombat/FlyingMachine_and_Slideshow",
        Focus_Hits = "Stereo Output/SFX/###PlayerGenerated/Hits/Focus Hits",
        Foley = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Foley",
        Footsteps = "Stereo Output/SFX/#Environment/Footsteps",
        Footsteps_Large = "Stereo Output/SFX/#Environment/Footsteps/Footsteps Large",
        Footsteps_Medium = "Stereo Output/SFX/#Environment/Footsteps/Footsteps Medium",
        Footsteps_Small = "Stereo Output/SFX/#Environment/Footsteps/Footsteps Small",
        FX_Looping = "Stereo Output/SFX/#Environment/FX Looping",
        FX_Looping = "Stereo Output/SFX/###PlayerGenerated/FX Looping",
        gnarlic = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/gnarlic",
        gourdo = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Tough Standard/gourdo",
        gourdo_elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Tough Elite/gourdo_elite",
        groak = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Tough Standard/groak",
        Hammer = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Hammer",
        Hammer_Regular = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Hammer/Hammer Regular",
        Hammer_Special = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Hammer/Hammer Special",
        Heal = "Stereo Output/SFX/##PlayerInteresting/Heal",
        Heart = "Stereo Output/SFX/#Environment/Heart",
        Hits = "Stereo Output/SFX/###PlayerGenerated/Hits",
        Hits_Player = "Stereo Output/SFX/####PlayerCritical/Hits Player",
        InMenu_Verb = "Stereo Output/InMenu_Verb",
        Item = "Stereo Output/SFX/#Environment/Item",
        Item_Land = "Stereo Output/SFX/#Environment/Item Land",
        Item_Land_CommnonUncommonRare = "Stereo Output/SFX/#Environment/Item Land/Item Land CommnonUncommonRare",
        Item_Land_Epic = "Stereo Output/SFX/#Environment/Item Land/Item Land Epic",
        Item_Land_Konjur = "Stereo Output/SFX/#Environment/Item Land/Item Land Konjur",
        Item_Land_Legendary = "Stereo Output/SFX/#Environment/Item Land/Item Land Legendary",
        Item_Looping = "Stereo Output/SFX/#Environment/Item/Item Looping",
        Item_Pickup = "Stereo Output/SFX/#Environment/Item Pickup",
        Item_Pickup_CommonUncommonRare = "Stereo Output/SFX/#Environment/Item Pickup/Item Pickup CommonUncommonRare",
        Item_Pickup_Epic = "Stereo Output/SFX/#Environment/Item Pickup/Item Pickup Epic",
        Item_Pickup_Konjur = "Stereo Output/SFX/#Environment/Item Pickup/Item Pickup Konjur",
        Item_Pickup_Legendary = "Stereo Output/SFX/#Environment/Item Pickup/Item Pickup Legendary",
        Knockdown = "Stereo Output/SFX/###PlayerGenerated/Hits/Knockdown",
        konjurBlob = "Stereo Output/SFX/#Environment/Item/konjurBlob",
        Levels = "Stereo Output/Music/Levels",
        Master_Bus = "",
        megatreemon = "Stereo Output/SFX/#Environment/SFX_Boss/megatreemon",
        megatreemon_abilities_highpri = "Stereo Output/SFX/#Environment/SFX_Boss/megatreemon/megatreemon_abilities_highpri",
        megatreemon_abilities_lowpri = "Stereo Output/SFX/#Environment/SFX_Boss/megatreemon/megatreemon_abilities_lowpri",
        megatreemon_tell_vo = "Stereo Output/SFX/#Environment/SFX_Boss/megatreemon/megatreemon_tell_vo",
        Menus = "Stereo Output/Music/Menus",
        Minigame = "Stereo Output/Music/Minigame",
        Minigame_Looping = "Stereo Output/Music/Minigame/Minigame Looping",
        Minigame_Stinger = "Stereo Output/Music/Minigame/Minigame Stinger",
        miniTreemon = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/miniTreemon",
        Mono_Output = "Mono Output",
        mossquito = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/mossquito",
        mothball = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/mothball",
        Music = "Stereo Output/Music",
        Musical = "Stereo Output/SFX/Musical",
        Music_Boss = "Stereo Output/Music/Music_Boss",
        NonCombat = "Stereo Output/SFX/NonCombat",
        NPC = "Stereo Output/SFX/NonCombat/Speech/NPC",
        Owlitzer = "Stereo Output/SFX/#Environment/SFX_Boss/Owlitzer",
        Player_Minions = "Stereo Output/SFX/#Environment/Player Minions",
        playerPower = "Stereo Output/SFX/###PlayerGenerated/playerPower",
        Polearm = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Polearm",
        Potion = "Stereo Output/SFX/###PlayerGenerated/Potion",
        Power_Fabled = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled",
        Power_Misc = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Misc",
        powerCrystal = "Stereo Output/SFX/#Environment/Item/powerCrystal",
        powerCrystal_rattle = "Stereo Output/SFX/#Environment/Item/powerCrystal/powerCrystal_rattle",
        PowerUp = "Stereo Output/SFX/##PlayerInteresting/PowerUp",
        Reverb = "Stereo Output/SFX/Reverb",
        Roll = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Roll",
        SFX = "Stereo Output/SFX",
        SFX_Critical_Submix___Local = "Stereo Output/SFX/####PlayerCritical/SFX Critical Submix - Local",
        SFX_Critical_Submix___Remote = "Stereo Output/SFX/####PlayerCritical/SFX Critical Submix - Remote",
        SFX_Important_Submix___Local = "Stereo Output/SFX/###PlayerGenerated/SFX Important Submix - Local",
        SFX_Important_Submix___Remote = "Stereo Output/SFX/###PlayerGenerated/SFX Important Submix - Remote",
        SFX_Movement_Submix___Local = "Stereo Output/SFX/#Environment/SFX Movement Submix - Local",
        SFX_Movement_Submix___Remote = "Stereo Output/SFX/#Environment/SFX Movement Submix - Remote",
        SFX_Normal_Submix___Local = "Stereo Output/SFX/##PlayerInteresting/SFX Normal Submix - Local",
        SFX_Normal_Submix___Remote = "Stereo Output/SFX/##PlayerInteresting/SFX Normal Submix - Remote",
        SFX_Boss = "Stereo Output/SFX/#Environment/SFX_Boss",
        SFX_NPC = "Stereo Output/SFX/NonCombat/SFX_NPC",
        SFX_Player = "Stereo Output/SFX/#PlayerAssociated/SFX_Player",
        Sheathe = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Foley/Sheathe",
        Shield = "Stereo Output/SFX/###PlayerGenerated/playerPower/Power Fabled/Shield",
        Shield_Break = "Stereo Output/SFX/####PlayerCritical/Shield Break",
        Shotput = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Shotput",
        Shotput_Travel = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits/Shotput/Shotput Travel",
        Skill = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Skill",
        Skill_Mvmt = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Skill/Skill Mvmt",
        Slideshow = "Stereo Output/_Meta/Slideshow",
        slowpoke = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/slowpoke",
        Speech = "Stereo Output/SFX/NonCombat/Speech",
        Speech_Player = "Stereo Output/SFX/NonCombat/Speech/Speech_Player",
        sporemon = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/sporemon",
        Status_Enemy = "Stereo Output/SFX/#Environment/Status Enemy",
        Status_Player = "Stereo Output/SFX/###PlayerGenerated/Status Player",
        Stereo_Output = "Stereo Output",
        Stingers = "Stereo Output/Music/Stingers",
        swarmy = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/swarmy",
        Teleport = "Stereo Output/SFX/###PlayerGenerated/playerPower/Teleport",
        thatcher = "Stereo Output/SFX/#Environment/SFX_Boss/thatcher",
        TitleScreen = "Stereo Output/Music/TitleScreen",
        totolili = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/totolili",
        Town = "Stereo Output/Music/Levels/Town",
        Trap_Warnings_and_Hits = "Stereo Output/SFX/####PlayerCritical/Trap Warnings and Hits",
        Traps = "Stereo Output/SFX/#Environment/Traps",
        treemon = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/treemon",
        UI = "Stereo Output/UI",
        UI_Diegetic = "Stereo Output/UI/UI Diegetic",
        UI_EndOfRun = "Stereo Output/UI/UI EndOfRun",
        UI_Error = "Stereo Output/UI/UI Error",
        UI_Hover = "Stereo Output/UI/UI Hover",
        UI_Hover_Generic = "Stereo Output/UI/UI Hover/UI Hover Generic",
        UI_Hover_Specific = "Stereo Output/UI/UI Hover/UI Hover Specific",
        UI_Input_Down = "Stereo Output/UI/UI Input Down",
        UI_Input_Up = "Stereo Output/UI/UI Input Up",
        UI_Minigame = "Stereo Output/UI/UI Minigame",
        UI_Overlay_Transitions = "Stereo Output/UI/UI Overlay Transitions",
        UI_Speech_Bubble = "Stereo Output/UI/UI Speech Bubble",
        UI_Stingers = "Stereo Output/UI/UI Stingers",
        UI_Text_Scroll = "Stereo Output/UI/UI Text Scroll",
        VendingMachine = "Stereo Output/SFX/#Environment/Heart/VendingMachine",
        Weapon_Hits = "Stereo Output/SFX/###PlayerGenerated/Hits/Weapon Hits",
        Weapon_Swings = "Stereo Output/SFX/###PlayerGenerated/Weapon Swings",
        Weapons_that_Get_Ducked_On_Hits = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Ducked On Hits",
        Weapons_that_Get_Muted_on_Hits = "Stereo Output/SFX/#PlayerAssociated/SFX_Player/Weapons that Get Muted on Hits",
        Wellspring = "Stereo Output/SFX/#Environment/Heart/Wellspring",
        Wellspring_Loop = "Stereo Output/SFX/#Environment/Heart/Wellspring/Wellspring Loop",
        Wellspring_Movement = "Stereo Output/SFX/#Environment/Heart/Wellspring/Wellspring Movement",
        woworm = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Weak Standard/woworm",
        yammo = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Tough Standard/yammo",
        yammo_elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Tough Elite/yammo_elite",
        zucco = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Standard/Creatures Tough Standard/zucco",
        zucco_elite = "Stereo Output/SFX/#Environment/Creatures/Creatures Combat/Creatures Elite/Creatures Tough Elite/zucco_elite",
        _Meta = "Stereo Output/_Meta",
    },


    Snapshot =
    {
        APlayerIsReviving = "Revive/APlayerIsReviving",
        Boss_HugeAttack = "Boss/Boss_HugeAttack",
        Boss_Intro = "Boss/Boss_Intro",
        Boss_Killshot = "Boss/Boss_Killshot",
        Boss_LowPassMusic = "Boss/Boss_LowPassMusic",
        Boss_Mix = "Boss/Boss_Mix",
        Boss_SustainedAttack = "Boss/Boss_SustainedAttack",
        CreatureWarning = "WarningsAndTells/CreatureWarning",
        DeathScreen = "UI_Screens/DeathScreen",
        DuckMusicBass = "FrequencyManagement/DuckMusicBass",
        DuckPiercing = "FrequencyManagement/DuckPiercing",
        DuckSomeSFXBass = "FrequencyManagement/DuckSomeSFXBass",
        Duck_DeathSounds = "Hacks and One-Offs/Duck_DeathSounds",
        Duck_Filter_LowHealth = "_BroadMixing/Duck_Filter_LowHealth",
        Duck_HyperDucking = "_BroadMixing/Duck_HyperDucking",
        Duck_HyperDucking_ = "_BroadMixing/Duck_HyperDucking+",
        Duck_Mortar_InitialHit = "_SpecificMixing/Duck_Mortar_InitialHit",
        Duck_Mute_ClearWeaponsAndHitsForCannonAmmo = "_SpecificMixing/Duck_Mute_ClearWeaponsAndHitsForCannonAmmo",
        Duck_PlayerHits = "Hacks and One-Offs/Duck_PlayerHits",
        Duck_Remote = "_BroadMixing/Duck_Remote",
        Duck_RollSounds = "_SpecificMixing/Duck_RollSounds",
        Duck_SFX_Player_Weapon_Hits = "_SpecificMixing/Duck_SFX_Player_Weapon_Hits",
        Duck_Sheathes = "Hacks and One-Offs/Duck_Sheathes",
        Duck_Travel = "_SpecificMixing/Duck_Travel",
        Duck_Wellspring_LP = "_SpecificMixing/Duck_Wellspring_LP",
        EliteCreatureWarning = "WarningsAndTells/EliteCreatureWarning",
        FadeOutMusicBeforeBossRoom = "Hacks and One-Offs/FadeOutMusicBeforeBossRoom",
        FullscreenOverlay = "UI_Screens/FullscreenOverlay",
        HitstopCutToBlack = "StuffThatHappensWhenYouDie/HitstopCutToBlack",
        Interacting = "Interacting",
        InTheTotem = "Hacks and One-Offs/InTheTotem",
        LastPlayerAliveIsReviving = "Revive/LastPlayerAliveIsReviving",
        ListeningEnvironment_Headphones = "ListeningEnvironments/ListeningEnvironment_Headphones",
        ListeningEnvironment_Speakers = "ListeningEnvironments/ListeningEnvironment_Speakers",
        ListeningEnvironment_SteamDeck = "ListeningEnvironments/ListeningEnvironment_SteamDeck",
        MenuOverlay = "UI_Screens/MenuOverlay",
        MomentaryBigAttack = "Hacks and One-Offs/MomentaryBigAttack",
        Mute_Ambience = "Mute/Mute_Ambience",
        Mute_Ambience_Bed = "Mute/Mute_Ambience_Bed",
        Mute_Ambience_Birds = "Mute/Mute_Ambience_Birds",
        Mute_and_Duck_WeaponSwings = "Mute/Mute_and_Duck_WeaponSwings",
        Mute_EndOfRun_Meters = "Hacks and One-Offs/Mute_EndOfRun_Meters",
        Mute_Everything_LoseFocus = "Mute_Everything_LoseFocus",
        Mute_Music = "Mute/Mute_Music",
        Mute_Music_Boss = "Mute/Mute_Music_Boss",
        Mute_Music_Dungeon = "Mute/Mute_Music_Dungeon",
        Mute_Music_Minigame_Looping = "Mute/Mute_Music_Minigame_Looping",
        Mute_Music_NonMenuMusic = "Mute/Mute_Music_NonMenuMusic",
        Mute_Music_NPCEncounters = "Mute/Mute_Music_NPCEncounters",
        Mute_Music_SoloStingers = "Mute/Mute_Music_SoloStingers",
        Mute_Music_Town = "Mute/Mute_Music_Town",
        Mute_SFX = "Mute/Mute_SFX",
        Mute_SFX_Looping = "Mute/Mute_SFX_Looping",
        Mute_SFX_Speech = "Mute/Mute_SFX_Speech",
        Mute_UI = "Mute/Mute_UI",
        Mute_UI_Error = "Mute/Mute_UI_Error",
        Mute_UI_Hover_Generic = "Mute/Mute_UI_Hover_Generic",
        Mute_UI_Hover_Specific = "Mute/Mute_UI_Hover_Specific",
        Mute_UI_OffScreenIndicator = "Mute/Mute_UI_OffScreenIndicator",
        Mute_UI_OverlayTransitions = "Mute/Mute_UI_OverlayTransitions",
        Mute_UI_TextScroll = "Mute/Mute_UI_TextScroll",
        NonCombatRoom = "UI_Screens/NonCombatRoom",
        PitchMusicDown24Semitones = "Hacks and One-Offs/PitchMusicDown24Semitones",
        PopupOverlay = "UI_Screens/PopupOverlay",
        Slideshow = "UI_Screens/Slideshow",
        TrapWarning = "WarningsAndTells/TrapWarning",
        TravelScreen = "UI_Screens/TravelScreen",
        Wanderer = "Wanderer/Wanderer",
    },


    Bank =
    {
        Ambiences = "Ambiences",
        Creatures = "Creatures",
        Emote = "Emote",
        Master = "Master",
        Music = "Music",
        Player_Mvmt = "Player_Mvmt",
        Powers = "Powers",
        Skills = "Skills",
        Town = "Town",
        UI = "UI",
        Weapons = "Weapons",
    },


    -- Parameters are not set by their path, but instead by their name. The following entries do not provide the path, but the string name for the parameter.

    -- LocalParameter: A parameter which is scoped to one individual event instance. Set these on an EventInstance to modify the behaviour of one single event.
    LocalParameter =
    {
        acidWarning = "acidWarning",
        activeCount_instigator = "activeCount_instigator",
        attack_isElectric = "attack_isElectric",
        bossName = "bossName",
        cannon_ammo_makeSoundsLouderToAssist = "cannon_ammo_makeSoundsLouderToAssist",
        cannon_ammo_numLowAmmoShotsRemaining = "cannon_ammo_numLowAmmoShotsRemaining",
        cannon_ammo_numLowAmmoShotsRemaining_scaled = "cannon_ammo_numLowAmmoShotsRemaining_scaled",
        cannon_ammo_percentDelta = "cannon_ammo_percentDelta",
        cannon_heavyShotType = "cannon_heavyShotType",
        cannon_mortarStrength = "cannon_mortarStrength",
        cannon_remainingAmmo_scaled = "cannon_remainingAmmo_scaled",
        cannon_shotType = "cannon_shotType",
        Cooking_Beat_1 = "Cooking_Beat_1",
        Cooking_Beat_2 = "Cooking_Beat_2",
        Cooking_beat_3 = "Cooking_beat_3",
        Cooking_Beat_4 = "Cooking_Beat_4",
        Cooking_Beat_5 = "Cooking_Beat_5",
        Cooking_Beat_6 = "Cooking_Beat_6",
        Cooking_Beat_7 = "Cooking_Beat_7",
        Cooking_Beat_8 = "Cooking_Beat_8",
        Cooking_Beat_9 = "Cooking_Beat_9",
        Cooking_Rating = "Cooking_Rating",
        Cooking_Rating_2 = "Cooking_Rating_2",
        Cooking_Rating_3 = "Cooking_Rating_3",
        Cooking_Rating_4 = "Cooking_Rating_4",
        Count = "Count",
        countDuringWindow_instigator = "countDuringWindow_instigator",
        counter_corestonesAccepted = "counter_corestonesAccepted",
        counter_corestonesSpawned = "counter_corestonesSpawned",
        count_continuous = "count_continuous",
        damage_received_mult = "damage_received_mult",
        distance = "distance",
        distanceToNearestPlayer = "distanceToNearestPlayer",
        distanceToTarget = "distanceToTarget",
        distance_normalized = "distance_normalized",
        empty = "empty",
        faction = "faction",
        faction_player_id = "faction_player_id",
        feeling = "feeling",
        gear_LP_spin_direction = "gear_LP_spin_direction",
        gear_LP_spin_speed = "gear_LP_spin_speed",
        healAmount = "healAmount",
        heart = "heart",
        heartLevel = "heartLevel",
        hitstop_frames = "hitstop_frames",
        HitStreakVolitileWeaponry = "HitStreakVolitileWeaponry",
        impactSequenceProgress = "impactSequenceProgress",
        isFocusAttack = "isFocusAttack",
        isInBossFlow = "isInBossFlow",
        isInteracting = "isInteracting",
        isInTrap = "isInTrap",
        isLastDestinationMarker = "isLastDestinationMarker",
        isLocalPlayerInTrap = "isLocalPlayerInTrap",
        isLocalPlayerInvolved = "isLocalPlayerInvolved",
        isMinibossRune = "isMinibossRune",
        item_amount = "item_amount",
        levels_gained = "levels_gained",
        local_discreteBinary = "local_discreteBinary",
        loop_time = "loop_time",
        masteryProgress = "masteryProgress",
        monsterPower = "monsterPower",
        Music_Bandicoot_clockFreq = "Music_Bandicoot_clockFreq",
        Music_Bandicoot_DashStinger = "Music_Bandicoot_DashStinger",
        Music_Bandicoot_isHiding = "Music_Bandicoot_isHiding",
        Music_Bandicoot_PillarFailStinger = "Music_Bandicoot_PillarFailStinger",
        Music_Bandicoot_PillarRevealStinger = "Music_Bandicoot_PillarRevealStinger",
        Music_BossComplete = "Music_BossComplete",
        Music_BossKillshot = "Music_BossKillshot",
        Music_BossPhase = "Music_BossPhase",
        Music_BossPhase_Skip = "Music_BossPhase_Skip",
        Music_BossVariation = "Music_BossVariation",
        Music_Boss_IsTransitioning = "Music_Boss_IsTransitioning",
        Music_Boss_VariationLoopCounter = "Music_Boss_VariationLoopCounter",
        Music_Dungeon_Progress = "Music_Dungeon_Progress",
        Music_InCombat = "Music_InCombat",
        Music_InCombat_Destination = "Music_InCombat_Destination",
        Music_InDeath = "Music_InDeath",
        Music_Megatreemon_RootTrigger = "Music_Megatreemon_RootTrigger",
        Music_Minigame_Phase = "Music_Minigame_Phase",
        Music_Owlitzer_IsFlapping = "Music_Owlitzer_IsFlapping",
        Music_Owlitzer_SwoopStinger_Miss = "Music_Owlitzer_SwoopStinger_Miss",
        Music_SlideShow_Section = "Music_SlideShow_Section",
        Music_SlideShow_SkipRequested = "Music_SlideShow_SkipRequested",
        normalized_lowHealthPercent = "normalized_lowHealthPercent",
        numBombs = "numBombs",
        numPlayersAlive = "numPlayersAlive",
        owlitzer_lockOn_progress = "owlitzer_lockOn_progress",
        polearm_drill_LP_speed = "polearm_drill_LP_speed",
        progress = "progress",
        progress_vendingMachine = "progress_vendingMachine",
        recentCount_instigator = "recentCount_instigator",
        run = "run",
        scale = "scale",
        screenPosition_X = "screenPosition_X",
        screenPosition_Y = "screenPosition_Y",
        sequenceRamp_stepped = "sequenceRamp_stepped",
        shotputAmmo = "shotputAmmo",
        skill_buffNextAttack_critChance = "skill_buffNextAttack_critChance",
        skill_chargeLevel = "skill_chargeLevel",
        skill_yammoPunch_playWhoosh = "skill_yammoPunch_playWhoosh",
        snapshotReleaseTime = "snapshotReleaseTime",
        spawnRate = "spawnRate",
        speech_blah = "speech_blah",
        Speed = "Speed",
        startCount_instigator = "startCount_instigator",
        thatcher_guitarJam_muteIfMusicPlaying = "thatcher_guitarJam_muteIfMusicPlaying",
        thatcher_guitarJam_muteIfSfxPlaying = "thatcher_guitarJam_muteIfSfxPlaying",
        tile_surface = "tile_surface",
        town_building_interact = "town_building_interact",
        town_building_interactable = "town_building_interactable",
        town_building_interactable_pulse = "town_building_interactable_pulse",
        twirl_LP_speed = "twirl_LP_speed",
        ui_easePercentage = "ui_easePercentage",
        ui_easeTimer = "ui_easeTimer",
        upgrade_level = "upgrade_level",
        userVolume_Ambience = "userVolume_Ambience",
        userVolume_Master = "userVolume_Master",
        userVolume_Mix_Mono = "userVolume_Mix_Mono",
        userVolume_Music = "userVolume_Music",
        userVolume_SFX = "userVolume_SFX",
        userVolume_Voice = "userVolume_Voice",
        weight = "weight",
        wellspring_bounce = "wellspring_bounce",
        wellspring_isExcited = "wellspring_isExcited",
        wellspring_pulse = "wellspring_pulse",
        wellspring_shake = "wellspring_shake",
        xp_percent = "xp_percent",
    },


    -- GlobalParameter: A global parameter which is readable by any event in the FMOD Studio project, without needing to be individually set on an EventInstance. Updating these can modify the behaviour of many events, so do so mindfully.
    GlobalParameter =
    {
        attenuation_hitCannonCounter = "attenuation_hitCannonCounter",
        attenuation_hitMortarCounter = "attenuation_hitMortarCounter",
        attenuation_shootCannonCounter = "attenuation_shootCannonCounter",
        autoAttenuateSpammyUI = "autoAttenuateSpammyUI",
        AutoAttenuateTextScroll = "AutoAttenuateTextScroll",
        cannon_isLastMortar = "cannon_isLastMortar",
        cannon_isPlayerSpammingWhenEmpty = "cannon_isPlayerSpammingWhenEmpty",
        critHitCounter = "critHitCounter",
        distanceToPlayer = "distanceToPlayer",
        electric_chainCount = "electric_chainCount",
        g_fadeOutMusicAndSendToReverb = "g_fadeOutMusicAndSendToReverb",
        g_isRunSummaryScreen = "g_isRunSummaryScreen",
        hitHammerCounter = "hitHammerCounter",
        hitShotputCounter = "hitShotputCounter",
        hitSpearCounter = "hitSpearCounter",
        inCombat = "inCombat",
        isAffectedByWanderer = "isAffectedByWanderer",
        isLocalPlayerInTotem = "isLocalPlayerInTotem",
        isMultiplayerGame = "isMultiplayerGame",
        lariatSwingCount = "lariatSwingCount",
        listeningEnvironment = "listeningEnvironment",
        lootCounter_common = "lootCounter_common",
        lootCounter_epic = "lootCounter_epic",
        lootCounter_konjur = "lootCounter_konjur",
        lootCounter_legendary = "lootCounter_legendary",
        lootCounter_rare = "lootCounter_rare",
        lootCounter_uncommon = "lootCounter_uncommon",
        Music_Boss_StingerCounter = "Music_Boss_StingerCounter",
        Music_InMenu = "Music_InMenu",
        Music_InMenu_Destination = "Music_InMenu_Destination",
        numFXHits = "numFXHits",
        numLocalPlayers = "numLocalPlayers",
        numPlayers = "numPlayers",
        teleportCounter = "teleportCounter",
        throwShotputCounter = "throwShotputCounter",
        thump_pitch = "thump_pitch",
        thump_quiet_pitch = "thump_quiet_pitch",
        usenewmixing = "usenewmixing",
        userVolume_Ambience_g = "userVolume_Ambience_g",
        userVolume_Master_g = "userVolume_Master_g",
        userVolume_Mix_Mono_g = "userVolume_Mix_Mono_g",
        userVolume_Music_g = "userVolume_Music_g",
        userVolume_SFX_g = "userVolume_SFX_g",
        userVolume_Voice_g = "userVolume_Voice_g",
        wellspring_isActive = "wellspring_isActive",
    },


}

return fmodtable